package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 省市
 *
 * @TableName province
 */
@Table(name = "province")
@Data
@Entity
public class Province implements Serializable {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "province_id")
    private String provinceId;

    /**
     * 省
     */
    @Column(name = "province_name")
    private String provinceName;

    /**
     * 编码
     */
    @Column(name = "province_code")
    private String provinceCode;

    /**
     * 父id
     */
    @Column(name = "province_parent_id")
    private String provinceParentId;

    /**
     * 删除标记
     */
    @Column(name = "del_flag")
    private Integer delFlag;

    private static final long serialVersionUID = 1L;
}