package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.MonthlySettlementMethodApplication;
import com.huigou.topsun.customer.domain.MonthlySettlementMethod;
import com.huigou.topsun.customer.domain.query.MonthlySettlementMethodQueryRequest;
import com.huigou.topsun.customer.domain.vo.MonthlySettlementMethodVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2023/12/20
 * description:
 * 月结方式表
 */
@Controller
@ControllerMapping("/monthlySettlementMethod")
public class MonthlySettlementMethodController extends CommonController {
    @Autowired
    private MonthlySettlementMethodApplication monthlySettlementMethodApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/customer/";
    }

    /**
     * 跳转到月结方式页面
     */
    public String forwardMonthlySettlementMethodList() {
        return forward("monthlySettlementMethodList");
    }

    /**
     * 获取月结方式列表
     */
    public String slicedMonthlySettlementMethodList() {
        SDO sdo = this.getSDO();
        MonthlySettlementMethodQueryRequest monthlySettlementMethodQueryRequest = sdo.toQueryRequest(MonthlySettlementMethodQueryRequest.class);

        return toResult(monthlySettlementMethodApplication.getList(monthlySettlementMethodQueryRequest));
    }

    /**
     * 跳转到添加页面
     */
    public String addMonthlySettlementMethodDetail() {
        return forward("monthlySettlementMethodDetail");
//        return forward("ESText");
    }

    /**
     * 保存月结方式
     */
    public String saveMonthlySettlementMethod() {
        MonthlySettlementMethodVo monthlySettlementMethodVo = this.getSDO().toObject(MonthlySettlementMethodVo.class);
        MonthlySettlementMethod monthlySettlementMethod = MonthlySettlementMethodVo.getMonthlySettlementMethod(monthlySettlementMethodVo);
        monthlySettlementMethodVo = monthlySettlementMethodApplication.saveAndUpdate(monthlySettlementMethod);

        return success(monthlySettlementMethodVo);
    }

    /**
     * 根据id删除月结方式
     */
    public String deleteMonthlySettlementMethodById() {
        List<String> ids = this.getSDO().getIds();
        monthlySettlementMethodApplication.deleteById(ids);

        return success();
    }

    /**
     * 根据id获取单个月结方式
     */
    public String showMonthlySettlementMethodDetail() {
        String methodId = this.getSDO().getString("methodId");
        MonthlySettlementMethodVo monthlySettlementMethodVo = monthlySettlementMethodApplication.getOneById(methodId);
        return forward("monthlySettlementMethodDetail", monthlySettlementMethodVo);
    }
}
