package com.huigou.topsun.technology.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.technology.domain.model.Process;
import lombok.Data;

import java.io.Serializable;

/**
 * 工序
 * @TableName process
 */
@Data
public class ProcessVo implements Serializable {

    /**
     * 工序ID
     */
    private String processId;

    /**
     * 工序名称
     */
    private String processName;

    /**
     * 工序说明
     */
    private String processRemark;

    /**
     * 工时
     */
    private Double workHours;

    /**
     * 工序类别(process_type)
     */
    private String processType;

    /**
     * 工序内容
     */
    private String processContent;

    public static Process getProcess(ProcessVo processVo){
        return JSON.parseObject(JSON.toJSONString(processVo),Process.class);
    }

    public static ProcessVo getProcessVo(Process process){
        return JSON.parseObject(JSON.toJSONString(process), ProcessVo.class);
    }
}