package com.huigou.topsun.technology.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.technology.application.TechnologyApplication;
import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.model.Technology;
import com.huigou.topsun.technology.domain.model.TechnologyProcess;
import com.huigou.topsun.technology.domain.query.TechnologyQueryRequest;
import com.huigou.topsun.technology.repository.TechnologyRepository;
import com.huigou.topsun.technology.vo.TechnologyVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author 16508
* @description 针对表【technology(工艺)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class TechnologyApplicationImpl extends BaseApplication implements TechnologyApplication {

    @Resource
    private TechnologyRepository technologyRepository;
    @Resource
    private TechnologyProcessApplication technologyProcessApplication;
    @Override
    public Map<String, Object> slicedTechnologyList(TechnologyQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "technology");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        model.putDictionary("technologyType", DictUtil.getDictionary("technologyType"));
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    @Override
    public TechnologyVo saveTechnology(TechnologyVo technologyVo) {
        Technology technology = TechnologyVo.getTechnology(technologyVo);
        technology = technologyRepository.saveAndFlush(technology);
        technologyVo.setTechnologyId(technology.getTechnologyId());
        return technologyVo;
    }

    @Override
    public TechnologyVo updateTechnologyVo(TechnologyVo technologyVo) {
        return this.saveTechnology(technologyVo);
    }

    @Override
    public void deleteTechnology(List<String> ids) {
        ids.forEach(technologyId->{
            List<TechnologyProcess> technologyProcessList = technologyProcessApplication.findByTechnologyId(technologyId);
            List<String> technologyProcessIds = technologyProcessList
                    .stream()
                    .map(TechnologyProcess::getTechnologyProcessId)
                    .collect(Collectors.toList());
            //删除工艺工序关系表
            technologyProcessApplication.deleteByTechnologyProcessIds(technologyProcessIds);
            //删除工艺表
            technologyRepository.delete(technologyId);
        });
    }

    @Override
    public TechnologyVo findTechnologyByTechnologyIdId(String technologyId) {
        Technology technology = technologyRepository.findOne(technologyId);
        return TechnologyVo.getTechnologyVo(technology);
    }


    @Override
    public Map<String, Object> queryTechnologyByProduct(TechnologyQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryTechnologyByProduct");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }
}




