package com.huigou.topsun.sap.costCenter.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.costCenter.application.CostCenterApplication;
import com.huigou.topsun.sap.costCenter.domain.CostCenter;
import com.huigou.topsun.sap.costCenter.domain.query.CostCenterQueryRequest;
import com.huigou.topsun.sap.costCenter.domain.vo.CostCenterVo;
import com.huigou.topsun.sap.costCenter.repository.CostCenterRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/11:09
 * @Description:
 */
@Service
public class CostCenterApplicationImpl extends BaseApplication implements CostCenterApplication {

    @Autowired
    private CostCenterRepository costCenterRepository;

    @Override
    public Map<String, Object> getCostCenterList(CostCenterQueryRequest costCenterQueryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "costCenter");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, costCenterQueryRequest);
        queryModel.putDictionary("KOSAR", DictUtil.getDictionary("KOSAR"));
        queryModel.putDictionary("PRCTR", DictUtil.getDictionary("PRCTR"));
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public CostCenterVo findCostCenterById(String id) {
        CostCenter costCenter = costCenterRepository.findOne(id);
        return CostCenterVo.getCostCenterVo(costCenter);
    }

    @Override
    public void deleteCostCenterById(List<String> ids) {
        for (String id : ids) {
            costCenterRepository.delete(id);
        }
    }

    @Override
    public void updateCostCenter(CostCenter costCenter) {
        costCenterRepository.saveAndFlush(costCenter);
    }

    @Override
    public void saveCostCenter(CostCenter costCenter) {

    }

    @Override
    public CostCenterVo saveAndUpdate(CostCenter costCenter) {
        return CostCenterVo.getCostCenterVo(costCenterRepository.saveAndFlush(costCenter));

    }
}
