package com.huigou.topsun.resource.domain;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;

import lombok.Data;

/**
 * 资源字段设置
 * @TableName resource_filed
 */
//@Schema(description = "资源字段设置")
@TableName(value ="resource_filed")
@Data
public class ResourceFiled implements Serializable {
    /**
     * 资源字段ID
     */
    //@Schema(description = "资源字段ID")
    @TableId(value = "resource_field_id")
    private String resourceFieldId;

    /**
     * 所属资源类型
     */
    //@Schema(description = "所属资源类型ID")
    @TableField(value = "resource_type_id")
    private String resourceTypeId;

    /**
     * 字段名
     */
    //@Schema(description = "字段名")
    @TableField(value = "resource_field_name")
    private String resourceFieldName;

    /**
     * 字段显示名
     */
    //@Schema(description = "字段显示名")
    @TableField(value = "resource_filed_title")
    private String resourceFiledTitle;

    /**
     * 字段类型
     */
    //@Schema(description = "字段类型，码表（resourceFieldType)）")
    @TableField(value = "resource_field_type")
    private String resourceFieldType;

    /**
     * 是否可见
     */
    //@Schema(description = "是否可见，码表（resourceFieldShow））")
    @TableField(value = "resource_field_show")
    private String resourceFieldShow;

    /**
     * 字段大小
     */
    //@Schema(description = "字段大小")
    @TableField(value = "resource_field_size")
    private Integer resourceFieldSize;

    /**
     * 整型长度
     */
    //@Schema(description = "整型长度")
    @TableField(value = "integer_length")
    private Integer integerLength;

    /**
     * 小数点位数
     */
    //@Schema(description = "小数点位数")
    @TableField(value = "decimal_precision")
    private Integer decimalPrecision;

    /**
     * 序号
     */
    //@Schema(description = "序号")
    @TableField(value = "sort_num")
    private Integer sortNum;

    /**
     * 对应码表的编码/选择的表的关联字段
     */
    //@Schema(description = "对应码表的编码")
    @TableField(value = "dict_code")
    private String dictCode;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}