package com.huigou.topsun.customer.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 月结方式表
 *
 * @TableName monthly_settlement_method
 */
@Table(name = "monthly_settlement_method")
@Entity
@Data
public class MonthlySettlementMethod implements Serializable {
    /**
     * 月结方式id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "method_id")
    private String methodId;

    /**
     * 月结方式
     */
    @Column(name = "method")
    private String method;

    /**
     * 状态
     */
    @Column(name = "status")
    private String status;

    /**
     * 序列
     */
    @Column(name = "sequence")
    private String sequence;

    private static final long serialVersionUID = 1L;
}