$(document).ready(function () {
    initResourceFieldGrid();
});

//初始化资源
function initResourceFieldGrid(){
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            UICtrl.addGridRow(resourceFieldGrid);
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#resourceFieldGrid');
            DataUtil.delSelectedRows({
                action: 'purchase/deleteProviderBids.ajax',
                param: {},
                gridManager: _grid,
                onSuccess: function () {
                    reloadFieldGrid();
                }
            });
        }
    });
    resourceFieldGrid = UICtrl.grid('#resourceFieldGrid', {
        columns: getGridColumns(),
        dataAction: 'server',
        url: web_app.name + '/resource/findResourceTypeFields.ajax',
        parms: {tableName:$("#tableName").val() || $("#parentTableName").val()},
        width: '99.8%',
        height: '400',
        checkbox: true,
        heightDiff: -5,
        sortName: 'contact',
        enabledEdit: true,
        sortOrder: 'asc',
        toolbar: toolbarOptions,
        /*onLoadData: function () {
            const contractId = getEntityId();
            if (!contractId) {
                return false;
            }
            if (gridEntityContactManager) {
                gridEntityContactManager.setParm('contractId', contractId);
            }
        }*/
    });
}

function getGridColumns(){
    var columns=[];
    columns.push({
        display: "字段名称", name: "resourceFiledTitle", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: true }
    });
    columns.push({
        display: "字段类型", name: "resourceFieldTypeTextView", width: 150, minWidth: 60, type: "string", align: "center",
        editor : {
            type : 'combobox',
            data : $("#resourceFieldType").combox('getJSONData'),
            required : true,
            valueField : 'resourceFieldType'
        }
    });
    columns.push({
        display: "是否可见", name: "resourceFieldShowTextView", width: 150, minWidth: 60, type: "string", align: "center",
        editor : {
            type : 'combobox',
            data : $("#yesorno").combox('getJSONData'),
            required : false,
            valueField : 'resourceFieldShow'
        }
    });
    columns.push({
        display: "字段大小", name: "resourceFieldSize", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: false }
    });
    columns.push({
        display: "整型长度", name: "integerLength", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: false }
    });
    columns.push({
        display: "小数点位数", name: "decimalPrecision", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: false }
    });
    columns.push({
        display: "序号", name: "sortNum", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: false }
    });
    columns.push({
        display: "数据字典", name: "dictCode", width: 150, minWidth: 60, type: "string", align: "center",
        editor: {type: 'text', required: false }
    });
    return columns;
}

function reloadFieldGrid() {
    var param = {tableName:$("#tableName").val()};
    $('#resourceFieldGrid').ligerGetGridManager().options.url =web_app.name + '/resource/findParentResourceTypeAndFields.ajax';
    _grid = UICtrl.getGridManager('#resourceFieldGrid');
    UICtrl.gridSearch(_grid, param);

}

// $('#ok').click(function () {
//     $('#submitForm').ajaxSubmit({
//         url: web_app.name + '/resource/saveResourceType.ajax',
//         param: {
//             resourceFields: $.toJSON(resourceFieldGrid.getData()),
//         },
//         success: function (data) {
//             //reloadData();
//         },
//     });
// })
