package com.huigou.topsun.util;

import org.junit.Test;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class TestSnowflake {

    public List<Long> list = new CopyOnWriteArrayList<>();

    @Test
    public void run() throws InterruptedException {

        generateTest();

//        new Snowflake(1);
        final Long id = Snowflake.nextId();
        Date date = new Date();
        date.setTime( (id>>18) + 1686211627000L );

        System.out.println(id);


    }

    /**
     * description  测试当前生成策略极限。
     * @author qinzhenguan
     * @createDate 2023/12/30 10:42
     */
    public void generateTest()throws InterruptedException  {

        TreadA t1 = new TreadA();
        TreadB t2 = new TreadB();
        t1.start();
        t2.start();

        while (list.size() < 60000) {
            Thread.sleep(500);
        }
        System.out.println(list.size());
        Map<Object, Long> map = list.stream().collect(Collectors.groupingBy(l -> l, Collectors.counting()));
        Map<Object, Long> sortedByCount = map.entrySet().stream()
                .sorted((e1, e2) -> e2.getValue().compareTo(e1.getValue()))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        List<Object> countList = map.entrySet().stream().filter(f -> f.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if(countList.size() > 0) {
            System.out.println("x");
        }
    }

    protected static long timeGen() {
        return  System.currentTimeMillis() / 1000;
    }

    public class TreadA extends Thread {

        @Override
        public void run() {
            super.run();
            //long timestamp = timeGen();
            for(int i = 0; i < 30000; i++) {
//                new Snowflake(1);
                long id = Snowflake.nextId();
                list.add(id);
            }

        }
    }

    public class TreadB extends Thread {

        @Override
        public void run() {
            super.run();
            for(int i = 0; i < 30000; i++) {
//                new Snowflake(1);
                long id = Snowflake.nextId();
                list.add(id);
            }
        }
    }
}
