package com.huigou.topsun.technology.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 工艺工序关系表
 * @TableName technology_process
 */
@Table(name="technology_process")
@Data
@Entity
public class TechnologyProcess implements Serializable {
    /**
     * 工艺节点条目ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "technology_process_id")
    private String technologyProcessId;

    /**
     * 工艺ID
     */
    @Column(name = "technology_id")
    private String technologyId;

    /**
     * 工序ID
     */
    @Column(name = "process_id")
    private String processId;

    /**
     * 条目序号
     */
    @Column(name = "sort_num")
    private Integer sortNum;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        TechnologyProcess other = (TechnologyProcess) that;
        return (this.getTechnologyProcessId() == null ? other.getTechnologyProcessId() == null : this.getTechnologyProcessId().equals(other.getTechnologyProcessId()))
            && (this.getTechnologyId() == null ? other.getTechnologyId() == null : this.getTechnologyId().equals(other.getTechnologyId()))
            && (this.getProcessId() == null ? other.getProcessId() == null : this.getProcessId().equals(other.getProcessId()))
            && (this.getSortNum() == null ? other.getSortNum() == null : this.getSortNum().equals(other.getSortNum()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getTechnologyProcessId() == null) ? 0 : getTechnologyProcessId().hashCode());
        result = prime * result + ((getTechnologyId() == null) ? 0 : getTechnologyId().hashCode());
        result = prime * result + ((getProcessId() == null) ? 0 : getProcessId().hashCode());
        result = prime * result + ((getSortNum() == null) ? 0 : getSortNum().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", technologyProcessId=").append(technologyProcessId);
        sb.append(", technologyId=").append(technologyId);
        sb.append(", processId=").append(processId);
        sb.append(", sortNum=").append(sortNum);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}