package com.huigou.topsun.sap.priceMasterData.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.sap.priceMasterData.domain.SapPriceMasterData;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/25
 * description:
 */
@Data
public class SapPriceMasterDataVo implements Serializable {
    /**
     * 主键id
     */
    private String id;

    /**
     * KSCHL-条件类型(可选)
     * 通过选择相应的条件类型维护不同的价格
     * PR01-工厂价格；
     * ZPR1-品牌价格
     */
    private String kschl;

    /**
     * VKORG-销售组织(可选)
     * 目前只能选择1000-广州科技销售组织，其它销售组织隐藏
     * 1000-广州科技销售组织；
     * 2000-广州金库销售组织；
     */
    private String vkorg;

    /**
     * VTWEG-分销渠道(可选)
     * 10-内销；
     * 20-外销；
     * 80-集团内
     */
    private String vtweg;

    /**
     * KUNNR-客户(可选)
     * 通过调用客户主数据查询接口，搜索到相应的客户编号与描述
     */
    private String kunnr;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 申请日期
     */
    private Date fillinDate;

    /**
     * 流程状态
     */
    private Integer status;

    /**
     * 申请人组织机构全路径id
     */
    private String fullId;

    /**
     * 组织机构id
     */
    private String organId;

    /**
     * 组织机构名称
     */
    private String organName;

    /**
     * 部门id
     */
    private String deptId;

    /**
     * 申请部门名称
     */
    private String deptName;

    /**
     * 岗位id
     */
    private String positionId;

    /**
     * 岗位名称
     */
    private String positionName;

    /**
     * 人员id
     */
    private String personMemberId;

    /**
     * 申请人员名称
     */
    private String personMemberName;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 联系方式
     */
    private String telePhone;


    public static SapPriceMasterDataVo getSapPriceMasterDataVo(SapPriceMasterData sapPriceMasterData) {
        return JSON.parseObject(JSON.toJSONString(sapPriceMasterData), SapPriceMasterDataVo.class);
    }

    public static SapPriceMasterData getSapPriceMasterData(SapPriceMasterDataVo sapPriceMasterDataVo) {
        return JSON.parseObject(JSON.toJSONString(sapPriceMasterDataVo), SapPriceMasterData.class);
    }
}
