package com.huigou.topsun.sap.priceMasterData.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.fixedAssets.domain.vo.SapFixedAssetsVo;
import com.huigou.topsun.sap.priceMasterData.application.SapPriceMasterDataApplication;
import com.huigou.topsun.sap.priceMasterData.domain.SapPriceMasterData;
import com.huigou.topsun.sap.priceMasterData.domain.query.SapPriceMasterDataItemQueryRequest;
import com.huigou.topsun.sap.priceMasterData.domain.query.SapPriceMasterDataQueryRequest;
import com.huigou.topsun.sap.priceMasterData.domain.vo.SapPriceMasterDataVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2023/12/25
 * description:
 */
@Controller
@ControllerMapping("sapPriceMasterData")
public class SapPriceMasterDataController extends CommonController {

    @Autowired
    private SapPriceMasterDataApplication sapPriceMasterDataApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/priceMasterData/";
    }

    /**
     * 跳转到价格主数据查询界面
     */
    public String forwardPriceMasterList(){
        return forward("sapPriceMasterDataList");
    }

    /**
     * 跳转到价格主数据维护界面
     */
    public String forwardPriceMasterDataDetail(){
        this.putAttribute("processDefinitionKey", sapPriceMasterDataApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");

        SapPriceMasterData sapPriceMasterData = new SapPriceMasterData();
        sapPriceMasterData.setStatusId(BizBillStatus.APPLYING.getId());
        /*
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPriceMasterData.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        // 填充数据
//        sapPriceMasterData.setBillCode(sapPriceMasterData.getBillCode());
        return forward("sapPriceMasterDataDetail",sapPriceMasterData);
    }

    /**
     * 跳转到价格主数据维护界面
     */
    public String showPriceMasterData() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPriceMasterDataVo sapPriceMasterDataVo = sapPriceMasterDataApplication.getPriceMasterDataById(id);
        return forward("sapPriceMasterDataDetail", sapPriceMasterDataVo);
    }

    /**
     * 价格主数据查询
     */
    public String slicedPriceMasterDataList(){
        SDO sdo = this.getSDO();
        SapPriceMasterDataQueryRequest queryRequest = sdo.toQueryRequest(SapPriceMasterDataQueryRequest.class);
        return toResult(sapPriceMasterDataApplication.queryPriceMasterDataList(queryRequest));
    }
    /**
     * 查询ItemList
     */
    public String slicedPriceMasterDataItemList(){
        SDO sdo = this.getSDO();
        SapPriceMasterDataItemQueryRequest queryRequest = sdo.toQueryRequest(SapPriceMasterDataItemQueryRequest.class);
        return toResult(sapPriceMasterDataApplication.queryPriceMasterDataItemList(queryRequest));

    }
    /**
     * 根据id获取价格主数据
     */
    public String showPriceMasterDataDetail(){
        String id = this.getSDO().getString("id");
        SapPriceMasterDataVo priceMasterDataById = sapPriceMasterDataApplication.getPriceMasterDataById(id);
        return success("sapPriceMasterDataDetail", priceMasterDataById);
    }

    /**
     * 根据id删除价格主数据
     */
    public String deletePriceMasterDataById(){
        List<String> ids = this.getSDO().getIds();
        sapPriceMasterDataApplication.deletePriceMasterDataById(ids);
        return success();
    }
}
