package com.huigou.topsun.sap.costCenter.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import com.topsunit.query.annotations.Dictionary;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/10:42
 * @Description:
 */
@Table(name = "sap_cost_center")
@Entity
@Data
public class CostCenter extends FlowBillAbstractEntity {

    /**
     * 成本中心编码
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 有效期自 默认当年1月1日
     */
    @Column(name = "datab")
    private Date datab;

    /**
     * 有效截至日 默认9999.12.31
     */
    @Column(name = "datbi")
    private Date datbi;

    /**
     * 名称
     */
    @Column(name = "ktext")
    private String ktext;

    /**
     * 描述
     */
    @Column(name = "ltext")
    private String ltext;

    /**
     * 负责人
     */
    @Column(name = "verak")
    private String verak;

    /**
     * 成本中心类型
     * 管理类	L
     * 销售类	V
     * 研发类	E
     * 间接生产类	G
     * 直接生产类	F
     */
    @Column(name = "kosar")
    @Dictionary("KOSAR")
    private String kosar;

    /**
     * 利润中心
     * 10001000 广州宝绅科技利润中心
     * 10001001 广州宝绅RFID利润中心
     */
    @Column(name = "prctr")
    @Dictionary("PRCTR")
    private String prctr;

    /**
     * 业务类型
     */
    @Column(name = "form_type")
    @Dictionary("formType")
    private String formType;

    /**
     * 创建原因	CHAR	100	手工输入
     */
    @Column(name = "reason")
    private String reason;

    /**
     * 联系方式
     */
    @Column(name = "tele_phone")
    private String telePhone;
    /**
     * ********************************返回接收数据***********************************
     */
    /**
     * 消息类型: S 成功,E 错误,W 警告,I 信息,A 中断
     */
    @Column(name = "TYPE")
    private String TYPE;
    /**
     * 消息类__ID
     */
    @Column(name = "message_id")
    private String messageId;
    /**
     * 消息编号
     */
    @Column(name = "NUMBER")
    private BigDecimal NUMBER;
    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String MESSAGE;
    /**
     * 应用程序日志,日志号
     */
    @Column(name = "LOG_NO")
    private String LOG_NO;

    @Override
    protected String getCodeRuleId() {
        return "sapCostCenter";
    }

}
