package com.huigou.topsun.resource.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.huigou.topsun.resource.domain.ResourceFieldValue;
import com.huigou.topsun.resource.domain.ResourceFiled;
import com.huigou.topsun.resource.vo.ResourceFiledVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【resource_filed(资源字段设置)】的数据库操作Mapper
* @createDate 2023-10-25 16:08:43
* @Entity com.topsun.resource.domain.ResourceFiled
*/
public interface ResourceFiledMapper extends BaseMapper<ResourceFiled> {

    void deleteByResourceTypeId(@Param("resourceTypeId") String resourceTypeId);

    List<ResourceFiled> findByResourceTypeId(@Param("resourceTypeId") String resourceTypeId);

    void createTable(@Param("tableName")String tableName,@Param("tableTile")String tableTile, @Param("resourceFields")List<ResourceFiledVo> resourceFields);

    int updateTableAddColumn(@Param("tableName")String tableName, @Param("resourceFields")List<ResourceFiledVo> resourceFields);

    int updateTableChangeColumn(@Param("tableName")String tableName, @Param("resourceFields")List<ResourceFiledVo> resourceFields);

    int insertData(@Param("tableName")String tableName,@Param("resourceFieldValues")List<ResourceFieldValue> resourceFieldValues);

    int updateData(@Param("id") String id, @Param("tableName")String tableName,@Param("resourceFieldValues")List<ResourceFieldValue> resourceFieldValues);

    List<Map<String,Object>> selectDataList(@Param("tableName")String tableName);

    int deleteDataById(@Param("tableName")String tableName,@Param("id") String id);

    void dropTableByResourceTableName(@Param("tableName") String tableName);

    Map<String, Object> findFieldValueByResourceTypeIdAndId(@Param("tableName") String tableName,@Param("id") String id);
}




