package com.huigou.topsun.quotation.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.quotation.application.QuotationApplication;
import com.huigou.topsun.quotation.domain.model.Quotation;
import com.huigou.topsun.quotation.domain.query.QuotationQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/28/14:05
 * @Description:
 */
@Controller
@ControllerMapping("/quotation")
public class QuotationController extends CommonController {
    @Resource
    private QuotationApplication quotationApplication;

    protected String getPagePath() {
        return "/biz/topsun/quotation/";
    }

    public String forwardQuotationList(){
        return forward("quotationList");
    }

    public String forwardAddQuotation(){
        this.putAttribute("processDefinitionKey", QuotationApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");

        Quotation quotation = new Quotation();
        quotation.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        quotation.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        quotation.setQuotationNo(quotation.getBillCode());
        return forward("quotationDetail",quotation);
    }

    public String showQuotation(){
        SDO sdo = this.getSDO();
        String bizId = sdo.getBizId();
        Quotation quotation = quotationApplication.findById(bizId);
        return forward("quotationDetail",quotation);
    }

    public String slicedQuotationList(){
        SDO sdo = this.getSDO();
        QuotationQueryRequest queryRequest = sdo.toQueryRequest(QuotationQueryRequest.class);
        return toResult(quotationApplication.slicedQuotationList(queryRequest));
    }

    public String print(){
        SDO sdo = this.getSDO();
        String quotationId = sdo.getString("quotationId");
        Map<String,Object> map = quotationApplication.loadPrintData(quotationId);
        return outputAndProcUnitHandlerPDF((String) map.get("url"),quotationId, map);
    }
}
