package com.huigou.topsun.proofing.domain.vo;

import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

/**
 * 样品申请与外观
 */
@Data
public class ProofingApplyAndLookedVo {
    /**
     * 申请单id
     */
    private String proofingApplyId;

    /**
     * 申请单号
     */
    private String proofingApplyNo;

    /**
     * 产品id
     */
    private String productId;

    /**
     * 客户id
     */
    private String customerId;
    /**
     * 品牌客户编号
     */

    private String customerCode;

//    /**
//     * 品牌编号名称
//     */
//    private String productCategoryName;

    /**
     * 版面需求时间
     */
    private Date proofingApplyPageNeedTime;

    /**
     * 完成日期
     */
    private Date proofingApplyCompleteDate;

    /**
     * 中文样品名
     */
    private String proofingApplySampleCnName;

    /**
     * 英文样品名
     */
    private String proofingApplySampleEnName;

    /**
     * 样品版次
     */
    private Integer proofingApplySampleVersion;

    /**
     * 样品规格
     */
    private Integer proofingApplySampleSize;

    /**
     * 样品数量
     */
    private Long proofingApplySampleNum;

    /**
     * 产量情况
     */
    private String proofingApplyOutputSituation;

    /**
     * 产品代号
     */
    private String proofingApplyProductNo;

    /**
     * 打样形式
     */
    private String proofingType;

    /**
     * 分配方式
     */
    private String proofingApplyAllocationType;

    /**
     * 表面处理
     */
    private String proofingApplySurfaceTreatment;

    /**
     * NG重新打样原因
     */
    private String proofingApplyNgReReason;

    /**
     *申请单状态
     */
    private String proofingApplyApplicationStatus;

    /**
     *测试标准
     */
    private String proofingApplyTestStandard;

    /**
     *测试标准
     */
    private String isOutput;
    /**
     *测试标准
     */
    private String isOut;
    /**
     *测试标准
     */
    private String isChange;
    /**
     * 塑胶袋结构
     */
    private String plasticBagStructure;

    /**
     * 产品类别
     */
    private String productCategoryName;

    /**
     * 长;单位cm
     */
    private Double productLength;

    /**
     * 宽;单位cm
     */
    private Double productWidth;

    /**
     * 高;单位cm
     */
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    private Double productThick;

    /**
     * 成品克重;单位g
     */
    private Double productWeight;

    /**
     * 角型
     */
    private String productAngleType;

    /**
     * 角度(单位mm)
     */
    private Double productAngle;

    /**
     * 孔径(单位mm)
     */
    private Double productAperture;

    /**
     * 单层厚(单位丝)
     */
    private Integer productSingleLayer;

    /**
     * 单重(单位KG)
     */
    private Double productSingleWeight;

    /**
     * 层数
     */
    private Integer productLayerNum;

    /**
     * 排版参数配置ID
     */
    private String productPublishedConfId;


    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */
    private Integer rowNum;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 搭版数
     */
    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */
    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */
    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */
    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */
    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */
    private Double sheetWidth;

    /**
     * 产品印张设置(product_sheet_conf)
     */
    private String productSheetConf;


}