package com.huigou.topsun.proofing.controller;

import com.huigou.topsun.proofing.application.WorkInstructionApplication;
import com.huigou.topsun.proofing.domain.vo.WorkInstructionVo;
import com.huigou.topsun.proofing.domain.workInstruction.model.WorkInstructionBaseInfo;
import com.huigou.topsun.proofing.domain.workInstruction.query.WorkInstructionBaseInfoQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;


@Controller
@ControllerMapping("/workInstruction")
public class WorkInstructionController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    WorkInstructionApplication workInstructionApplication;



    /**
     * 跳转打样制造查询页
     * @return
     */
    public String forwardWorkInstructionList(){
        return forward("workInstructionList");
    }

    /**
     * 跳转作业指导书
     * 如果有productId参数，就说明从打样制造单发送的请求，携带该参数跳转
     * @return
     */
    public String forwardWorkInstruction(){
        SDO sdo = this.getSDO();
        String workInstructionApplyId = sdo.getString("workInstructionApplyId");
        if(workInstructionApplyId!=null&&!"".equals(workInstructionApplyId)) this.putAttribute("workInstructionApplyId", workInstructionApplyId);
        return forward("workInstruction");
    }


    /**
     * 编辑作业指导书
     * @return
     */

    public String saveWorkInstruction(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = workInstructionApplication.saveWorkInstruction(sdo);
        return toResult(map);
    }

    /**
     * 分页查询作业书
     * @return
     */
    public String slicedQueryWorkInstructionList(){
        SDO sdo = this.getSDO();
        WorkInstructionBaseInfoQueryRequest workInstructionQueryRequest = sdo.toQueryRequest(WorkInstructionBaseInfoQueryRequest.class);
        Map<String, Object> map = workInstructionApplication.slicedWorkInstructionBaseInfoList(workInstructionQueryRequest);
        return toResult(map);
    }
    /**
     *  跳转作业书详情页
     */
    public String forwardDetailsWorkInstruction(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("isDetailPage","true");
        WorkInstructionVo workInstructionVo =(id==null||"".equals(id))?null: workInstructionApplication.getWorkInstructionVoById(id);
        return forward("workInstruction",workInstructionVo);
    }

    public String deleteWorkInstruction(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        workInstructionApplication.deleteWorkInstructionByIds(ids);
        return success();
    }
}

