package com.huigou.topsun.product.application.impl;

import com.huigou.topsun.product.application.BrandApplication;
import com.huigou.topsun.product.domain.Brand;
import com.huigou.topsun.product.repository.BrandRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
* @author 16508
* @description 针对表【brand(品牌)】的数据库操作Service实现
* @createDate 2023-11-22 10:24:31
*/
@Service
public class BrandApplicationImpl implements BrandApplication {

    @Autowired
    private BrandRepository brandRepository;

    @Override
    public Map<String, Object> querySelectableInFactoryName() {
        ArrayList<Brand> brands = this.findAll();
        Map<String, Brand> map = brands.stream().collect(Collectors.toMap(Brand::getBrandName, (b) -> b));
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("map", map);
        resultMap.put("list", brands);
        return resultMap;
    }

    @Override
    public ArrayList<Brand> findAll() {
        return (ArrayList<Brand>) brandRepository.findAll();
    }


}




