package com.huigou.topsun.proofing.domain.workInstruction.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 制作单可选属性
 * @TableName work_instruction_optional_attribute
 */
@Table(name="work_instruction_optional_attribute")
@Entity
@Data
public class WorkInstructionOptionalAttribute implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "work_instruction_optional_attribute_id")
    private String workInstructionOptionalAttributeId;

    /**
     * 制作工厂
     */
    @Column(name = "make_factory")
    private String makeFactory;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 版面
     */
    private String page;

    /**
     * 材料代号
     */
    @Column(name = "material_code")
    private String materialCode;

    /**
     * 产品代号
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 英文代号
     */
    @Column(name = "product_en_code")
    private String productEnCode;

    /**
     * 型体配色
     */
    @Column(name = "body_color")
    private String bodyColor;

    /**
     * 客户料号
     */
    @Column(name = "customer_material_code")
    private String customerMaterialCode;

    /**
     * 版本号
     */
    @Column(name = "version_no")
    private String versionNo;

    /**
     * 是否创建新规格书
     */
    @Column(name = "is_new_specification")
    private String isNewSpecification;

    /**
     * 规格书编号
     */
    @Column(name = "specification_no")
    private String specificationNo;

    /**
     * 作业指导书id
     */
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    private static final long serialVersionUID = 1L;
}