package com.huigou.topsun.product.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.product.domain.SizeGroup;
import lombok.Data;


import java.io.Serializable;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/11
 * description:
 */
@Data
public class SizeGroupVo implements Serializable {
    /**
     * 尺码组id
     */
    private String sizeGroupId;

    /**
     * 尺码组名称
     */
    private String sizeGroupName;

    /**
     * 尺码组编码
     */
    private String sizeGroupCode;

    /**
     * 尺码组类型
     */
    private String sizeGroupType;

    /**
     * 录入人
     */
    private String createdByName;

    /**
     * 录入人id
     */
    private String createdById;

    /**
     * 录入时间
     */
    private Date createdDate;

    /**
     * 修改人id
     */
    private String lastModifiedById;

    /**
     * 修改人
     */
    private String lastModifiedByName;

    /**
     * 修改日期
     */
    private Date lastModifiedDate;

    public static SizeGroupVo getSizeGroupVo(SizeGroup sizeGroup){
        return JSON.parseObject(JSON.toJSONString(sizeGroup), SizeGroupVo.class);
    }

    public static SizeGroup getSizeGroup(SizeGroupVo sizeGroupVo){
        return JSON.parseObject(JSON.toJSONString(sizeGroupVo),SizeGroup.class);
    }
}
