package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 尺码组主表
 * @TableName size_group
 */
@Table(name="size_group")
@Entity
@Data
public class SizeGroup implements Serializable {
    /**
     * 尺码组id
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
            @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "size_group_id")
    private String sizeGroupId;

    /**
     * 尺码组名称
     */
    @Column(name = "size_group_name")
    private String sizeGroupName;

    /**
     * 尺码组编码
     */
    @Column(name = "size_group_code")
    private String sizeGroupCode;

    /**
     * 尺码组类型
     */
    @Column(name = "size_group_type")
    private String sizeGroupType;

    /**
     * 录入人
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 录入人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 录入时间
     */
    @Column(name = "created_date")
    private Date createdDate;

    /**
     * 修改人id
     */
    @Column(name = "last_modified_by_id")
    private String lastModifiedById;

    /**
     * 修改人
     */
    @Column(name = "last_modified_by_name")
    private String lastModifiedByName;

    /**
     * 修改日期
     */
    @Column(name = "last_modified_date")
    private Date lastModifiedDate;


    private static final long serialVersionUID = 1L;
}