package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品loss配置
 * @TableName product_loss
 */
@Table(name="product_loss")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductLoss implements Serializable {
    /**
     * 产品lossID
     */
    @Id
    @Column(name = "product_loss_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productLossId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productId;

    /**
     * 产品最大loss数量
     */
    @Column(name = "product_loss_max")
    private Integer productLossMax;

    /**
     * loss比率(单位%)
     */
    @Column(name = "product_loss_rate")
    private Double productLossRate;

    /**
     * 冗余量
     */
    @Column(name = "product_loss_redundance")
    private Double productLossRedundance;

    /**
     * 备注信息
     */
    @Column(name = "product_loss_remark")
    private String productLossRemark;

    /**
     * 客户名称
     */
    @Column(name = "customer_name")
    private String customerName;

    public BigDecimal getProductLossId() {
        return productLossId;
    }

    public void setProductLossId(String productLossId) {
        this.productLossId = (productLossId != null) ? new BigDecimal(productLossId) : null;
    }

    public BigDecimal getProductId() { return productId; }

    public void setProductId(String productId) {
        this.productId = (productId != null) ? new BigDecimal(productId) : null;
    }

    public Integer getProductLossMax() {
        return productLossMax;
    }

    public void setProductLossMax(Integer productLossMax) {
        this.productLossMax = productLossMax;
    }

    public Double getProductLossRate() {
        return productLossRate;
    }

    public void setProductLossRate(Double productLossRate) {
        this.productLossRate = productLossRate;
    }

    public Double getProductLossRedundance() {
        return productLossRedundance;
    }

    public void setProductLossRedundance(Double productLossRedundance) {
        this.productLossRedundance = productLossRedundance;
    }

    public String getProductLossRemark() {
        return productLossRemark;
    }

    public void setProductLossRemark(String productLossRemark) {
        this.productLossRemark = productLossRemark;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}