package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品版面信息
 * @TableName product_face
 */
@Table(name="product_face")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductFace implements Serializable {
    /**
     * 产品版面ID
     */
    @Id
    @Column(name = "product_face_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productFaceId;

    /**
     * 产品版面图片
     */
    @Column(name = "product_image")
    private String productImage;

    public BigDecimal getProductFaceId() {
        return productFaceId;
    }

    public void setProductFaceId(String productFaceId) {
        this.productFaceId = (productFaceId != null) ? new BigDecimal(productFaceId) : null;
    }

    public String getProductImage() {
        return productImage;
    }

    public void setProductImage(String productImage) {
        this.productImage = productImage;
    }
}