package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerPayInfoApplication;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import com.huigou.topsun.customer.domain.query.CustomerPayInfoQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerPayInfoVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 *    客户付款信息
 */
@Controller
@ControllerMapping("/customerPayInfo")
public class CustomerPayInfoController extends CommonController {
    @Autowired
    private CustomerPayInfoApplication customerPayInfoApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/custcomer/";
    }

    /**
     * 跳转到客户付款信息展示页面
     */
    public String forwardCustomerPayInfoList() {
        return forward("customerPayInfoList");
    }
    /**
     * 跳转到客户付款信息新增页面
     */
    public String saveCustomerPayInfoDetail() {
        return forward("customerPayInfoDetail");
    }

    /**
     * 获取客户付款信息
     */
    public String slicedCustomerPayInfoList() {
        SDO sdo = this.getSDO();
        CustomerPayInfoQueryRequest queryRequest = sdo.toQueryRequest(CustomerPayInfoQueryRequest.class);

        return toResult(customerPayInfoApplication.getCustomerPayInfoList(queryRequest));
    }

    /**
     * 添加、修改客户付款信息
     */
    public String saveCustomerPayInfo() {
        SDO sdo = this.getSDO();
        CustomerPayInfoVo customerPayInfoVo = sdo.toObject(CustomerPayInfoVo.class);
        CustomerPayInfo customerPayInfo = CustomerPayInfoVo.getCustomerPayInfo(customerPayInfoVo);
        // 获取操作人信息
        String personMemberName = sdo.getOperator().getPersonMemberName();
        String personMemberId = sdo.getOperator().getPersonMemberId();
        if (StringUtil.isNotBlank(customerPayInfo.getCustomerPayInfoId())) {
            // 封装修改人信息
            customerPayInfo.setLastModifiedByName(personMemberName);
            customerPayInfo.setLastModifiedById(personMemberId);
            customerPayInfoVo = customerPayInfoApplication.updateCustomerPayInfo(customerPayInfo);
        } else {
            // 封装创建人信息
            customerPayInfo.setCreatedById(personMemberId);
            customerPayInfo.setCreatedByName(personMemberName);
            customerPayInfoVo = customerPayInfoApplication.saveCustomerPayInfo(customerPayInfo);
        }

        return success(customerPayInfoVo);
    }

    /**
     * 删除客户付款信息
     */
    public String deleteCustomerPayInfo() {
        List<String> ids = this.getSDO().getIds();
        customerPayInfoApplication.deleteCustomerPayInfo(ids);
        return success();
    }

    /**
     * 根据id获取客户付款信息
     */
    public String findCustomerPayInfoById() {
        SDO sdo = this.getSDO();
        String customerPayInfoId = sdo.getString("customerPayInfoId");
        CustomerPayInfoVo customerPayInfoVo = customerPayInfoApplication.getCustomerPayInfoById(customerPayInfoId);
        return success(customerPayInfoVo);
    }
}
