package com.huigou.topsun.customer.controller;

import com.huigou.topsun.customer.application.CustomerBaseInfoApplication;
import com.huigou.topsun.customer.application.CustomerApplication;
import com.huigou.topsun.customer.domain.CustomerBank;
import com.huigou.topsun.customer.domain.query.CustomerQueryRequest;
import com.huigou.topsun.customer.domain.Province;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Controller
@ControllerMapping("/customer")
public class CustomerController extends CommonController {
    @Autowired
    private CustomerBaseInfoApplication customerBaseInfoApplication;
    @Autowired
    private CustomerApplication customerApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/customer/";
    }

    /**
     * 转跳到客户信息列表页面
     *
     * @return
     */
    public String forwardCustomerList() {
        return forward("customerList");
    }

    /**
     * 分页展示客户信息列表
     *
     * @return
     */
    public String findCustomer() {
        SDO sdo = this.getSDO();
        CustomerQueryRequest customerQueryRequest = sdo.toQueryRequest(CustomerQueryRequest.class);

        return toResult(customerApplication.findCustomerByPage(customerQueryRequest));
    }

    /**
     * 分页展示客户联系人信息
     *
     * @return
     */
    public String slicedContactList() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        //ContactQueryRequest contactQueryRequest = sdo.toQueryRequest(ContactQueryRequest.class);
        return packGridDataAndResult(customerApplication.findContactByPage(customerId));
    }


    /**
     * 转跳到客户详细信息页面
     * @return
     */
    public String forwardCustomerDetail() {

        CustomerVo customerVo = loadCustomerDetail();
        CustomerBank customerBank = loadCustomerBank();
        if (customerBank != null) {
            BeanUtils.copyProperties(customerBank, customerVo);
        }
        return forward("customerDetail", customerVo);
    }

    /**
     * 新增客户，转跳到新增页面
     * @return
     */
    public String addCustomerDetail() {
        return forward("customerDetail");
    }

    /**
     * 根据id列表删除用户
     * @return
     */
    public String deleteCustomer() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        //TODO
        //删除操作

        return success();
    }

    /**
     * 保存客户信息（多表保存，添加事务）
     * @return
     */
    public String saveCustomer() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        //TODO
        //保存客户信息
        return null;
    }
    /**
     * 展示客户省市数据，如果客户的省份编码是省级行政单位，直接返回省份数据，
     * 如果客户的省份编码是二级或者三级行政单位，则需要返回对应的省级或者市级行政单位
     *
     * @return
     */
    public String findProvince() {
        SDO sdo = this.getSDO();
        //获取省份编码
        String provinceCode = sdo.getString("provinceCode");
        List<Province> provinceList = new ArrayList<>();
        if (!StringUtils.isEmpty(provinceCode)) {
            provinceList = customerBaseInfoApplication.findByProvinceCode(provinceCode);
        }
        List<String> provinceNameList = provinceList.stream().map(province -> province.getProvinceName()).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap<>();
        map.put("provinceNameList", provinceNameList);
        return toResult(map);
    }

    /**
     * 客户详细信息展示
     *
     * @return
     */
    public CustomerVo loadCustomerDetail() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        CustomerVo customerVo = customerBaseInfoApplication.findCustomerByCustomerId(customerId);
        return customerVo;
    }

    /**
     * 加载客户银行信息
     *
     * @return
     */
    public CustomerBank loadCustomerBank() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        CustomerBank customerBank = customerBaseInfoApplication.findCustomerBankByCustomerId(customerId);
        return customerBank;
    }

    /**
     * 根据id列表删除联系人
     * @return
     */
    public String deleteContact() {
        SDO sdo = getSDO();
        List<String> ids = sdo.getIds();
        customerApplication.deleteContactByIds(ids);
        return success();
    }

    /**
     * 删除客户及其附属信息
     * @return
     */
    public String deleteCustomerAndAffiliatedInfoByCustomerId() {
        SDO sdo = getSDO();
        String customerId = sdo.getString("customerId");
        //TODO
        //多表联删
        return success();
    }




}
