package com.huigou.topsun.customer.application.Impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.customer.application.CustomerRelatedApplication;
import com.huigou.topsun.customer.domain.CustomerRelated;
import com.huigou.topsun.customer.domain.query.CustomerRelatedQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerRelatedVo;
import com.huigou.topsun.customer.repository.CustomerRelatedRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 */
@Service
public class CustomerRelatedApplicationImpl extends BaseApplication implements CustomerRelatedApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/customer/customerMapper.xml";
    @Autowired
    private CustomerRelatedRepository customerRelatedRepository;

    @Override
    public List<CustomerRelated> getCustomerRelatedList(String customerId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH,"customerRelated");
        List<CustomerRelated> customerRelatedList = sqlExecutorDao.queryToList(queryDescriptor.getSql(), CustomerRelated.class, customerId);
        return customerRelatedList;
    }

    @Override
    public CustomerRelatedVo saveCustomerRelated(CustomerRelated customerRelated) {

        // 封装时间
        long timestamp = System.currentTimeMillis();
        customerRelated.setCreatedDate(new Date(timestamp));

        customerRelated = customerRelatedRepository.saveAndFlush(customerRelated);
        return CustomerRelatedVo.getCustomerRelatedVo(customerRelated);

    }

    @Override
    public void deleteCustomerRelated(List<String> ids) {
        ids.forEach(id -> customerRelatedRepository.delete(id));
    }


}
