package com.huigou.topsun.base.coderule.domain.model;

import com.huigou.exception.ApplicationException;
import com.huigou.util.StringUtil;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 编码规则类别
 * 
 * @author xiexin
 */
public enum CodeRuleKind {
    PURCHASE("purchase", "采购编号", "AP"), CONTRACT("contract", "合同编号", "CT");

    private String id;

    private String name;

    private String prefix;

    private CodeRuleKind(String id, String name, String prefix) {
        this.id = id;
        this.name = name;
        this.prefix = prefix;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getPrefix() {
        return prefix;
    }

    public static Map<String, String> getMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(CodeRuleKind.values().length);
        for (CodeRuleKind c : CodeRuleKind.values()) {
            map.put(c.getId(), c.getName());
        }
        return map;
    }

    public static CodeRuleKind fromId(String id) {
        if (StringUtil.isNotBlank(id)) {
            for (CodeRuleKind c : CodeRuleKind.values()) {
                if (c.getId().equals(id)) {
                    return c;
                }
            }
        }
        throw new ApplicationException("错误的编号规则类型!");
    }
}
