var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadQuotationListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadQuotationListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        printHandler :function(){
            printHandler();
        }
        /*updateHandler: function(){
            updateHandler();
        },
        deleteHandler: deleteHandler,*/
    });
    gridManager = UICtrl.grid("#quotationListGrid", {
        columns: [
            {
                display: "报价单类型",
                name: "quotationTypeTextView",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "客户名称",
                name: "customerManagerId",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {display: "报价日期", name: "quotationDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "报价单号", name: "quotationNo", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "客户是否签回", name: "customerSignBackTextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "创建人", name: "personMemberName", width: 100, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/quotation/slicedQuotationList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            viewHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function addHandler(){
	UICtrl.addTabItem({
		tabid: 'addQuotation',
		text: "新增报价需求单",
		url: web_app.name + '/quotation/forwardAddQuotation.job'
	});
}

function viewHandler(data){
    UICtrl.addTabItem({
        tabid: 'addQuotation' + data.quotationId,
        text: "查看报价需求单",
        url: web_app.name + '/quotation/showQuotation.job?bizId='+data.quotationId
    });
}

function printHandler(){
    var row = DataUtil.getUpdateRow(gridManager);
    if (!row) {
        return;
    }
    if (row.status != 3){
        Public.tip("请审批完成再打印!");
        return;
    }
    Public.openPostWindow(web_app.name+'/quotation/print.load',{quotationId :row.quotationId});
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}



