var contactGridManager = null;
var baosheEmailGridManager = null;
var customerEmailGridManager = null;
var customerRelatedGridManager = null;
var customerPayInfoGridManager = null;
$(document).ready(function () {
    initializeTab();
    initializeUI();
    loadContactListGrid();
    bindEvent();
    loadBaoshenEmailListGrid();
    loadCustomerEmailListGrid();
    loadCustomerRelatedListGrid();
    loadCustomerPayInfoListGrid();
});


function initializeUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function initializeTab() {
    $('#customerTab').tab();
    $('#emailTab').tab()
}


function loadContactListGrid() {
    //增删改控件
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addContactHandler();
        },
        deleteHandler: function () {
            deleteContactHandler();
        }
    });
    contactGridManager = UICtrl.grid("#contactListGrid", {
        columns: [
            {
                display: "联系人名称", name: "contactName", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "联系人电话", name: "contactPhone", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "传真", name: "contactFax", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "text"
                }
            },
            {
                display: "邮箱", name: "contactMail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customer/slicedContactList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,

    });
    UICtrl.setSearchAreaToggle(contactGridManager);
}


//添加联系人
function addContactHandler() {
    UICtrl.addGridRow(contactGridManager);
}

//删除联系人
function deleteContactHandler() {
    var _grid = UICtrl.getGridManager('#contactListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customer/deleteContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerContactId',
            onSuccess: function () {
                reloadResourceGrid();
            }
        }
    )
}


function loadBaoshenEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(baosheEmailGridManager);
            },
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#baoshenEmailListGrid');
                DataUtil.delSelectedRows(
                    {
                        action: 'customer/deleteBaoshenEmail.ajax',
                        param: {},
                        gridManager: _grid,
                        idFieldName: 'customerDebtContactId',
                        onSuccess: function () {
                            baosheEmailGridManager.loadData();
                        }
                    }
                )
            }
        }
    );
    baosheEmailGridManager = UICtrl.grid("#baoshenEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },

            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },
            },
            {
                display: "开启邮件发送", name: "sendEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 0},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function loadCustomerEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerEmailGridManager);
            },
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#customerEmailListGrid');
                DataUtil.delSelectedRows(
                    {
                        action: 'customer/deleteCustomerEmail.ajax',
                        param: {},
                        gridManager: _grid,
                        idFieldName: 'customerDebtContactId',
                        onSuccess: function () {
                            customerEmailGridManager.loadData();
                        }
                    }
                )
            }
        }
    );
    customerEmailGridManager = UICtrl.grid("#customerEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "开启邮件发送", name: "sendEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 1},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function loadCustomerRelatedListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerRelatedGridManager);
            },
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#customerRelatedListGrid');
                DataUtil.delSelectedRows(
                    {
                        action: 'customer/deleteCustomerRelated.ajax',
                        param: {},
                        gridManager: _grid,
                        idFieldName: 'customerRelatedId',
                        onSuccess: function () {
                            customerRelatedGridManager.loadData();
                        }
                    }
                )
            }
        }
    );
    customerRelatedGridManager = UICtrl.grid("#customerRelatedListGrid", {
        columns: [
            {
                display: "关联客户编码",
                name: "customerCodeRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户简称",
                name: "customerShortNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户全称",
                name: "customerNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },

        ],
        dataAction: "server",
        url: web_app.name + '/customerRelated/slicedCustomerRelatedList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function loadCustomerPayInfoListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerPayInfoGridManager);
            },
            deleteHandler: function () {
                var _grid = UICtrl.getGridManager('#customerPayInfoListGrid');
                DataUtil.delSelectedRows(
                    {
                        action: 'customer/deleteCustomerPayInfo.ajax',
                        param: {},
                        gridManager: _grid,
                        idFieldName: 'customerPayInfoId',
                        onSuccess: function () {
                            customerPayInfoGridManager.loadData();
                        }
                    }
                )
            }
        }
    );
    customerPayInfoGridManager = UICtrl.grid("#customerPayInfoListGrid", {
        columns: [
            {
                display: "支付方户名",
                name: "customerPayAccountName",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "date", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "修改人", name: "lastModifiedByName", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "修改时间", name: "lastModifiedDate", width: 200, minWidth: 60, type: "date", align: "left",
                editor: {
                    required: true, type: "text",
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customer/slicedContactList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}


function bindEvent() {
    $("#save").click(function () {//保存整体保存
        saveData();
    })

    $("#close").click(function () {//关闭
        closeDispatchTabItem();
    })
}

//右上角的保存控件
function saveData() {
    // var contactList
}

function closeDispatchTabItem() {
    UICtrl.closeCurrentTab();
}
