package com.huigou.topsun.quotation.vo;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 报价单明细
 * @TableName quotation_item
 */
@Data
public class QuotationItemVo implements Serializable {
    private String quotationItemId;

    /**
     * 报价单id
     */
    private String quotationId;

    /**
     * 序号/行项目
     */
    private Integer sequence;

    /**
     * 产品id
     */
    private String productId;

    /**
     * 名称
     */
    private String productName;

    /**
     * 产品代号
     */
    private String productCodeName;

    /**
     * 图片
     */
    private String picture;


    /**
     * 产品参数
     */
    private String productParameter;

    /**
     * 含13%增值税&含运费单价
     */
    private BigDecimal taxPrice;

    /**
     * 出厂价单价
     */
    private BigDecimal price;

    /**
     * 最小起订量
     */
    private BigDecimal moq;

    /**
     * 币别（码表currency）
     */
    private String currency;

    /**
     * 备注
     */
    private String remark;

    /**
     * 单位
     */
    private String productUnit;
}