package com.huigou.topsun.quotation.domain.model;

import java.util.Date;
import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * 报价单
 * @TableName quotation
 */
@Table(name="quotation")
@Data
@Entity
public class Quotation extends FlowBillAbstractEntity {
    /**
     * 报价单id
     */
    @Column(name = "quotation_id")
    private String quotationId;

    /**
     * 报价单类型（码表quotation_type）
     */
    @Column(name = "quotation_type")
    private String quotationType;

    /**
     * 品牌/工厂客户id
     */
    @Column(name = "customer_manager_id")
    private String customerManagerId;

    /**
     * 报价日期
     */
    @Column(name = "quotation_date")
    private Date quotationDate;

    /**
     * 修改人id
     */
    @Column(name = "update_by")
    private String updateBy;

    /**
     * 修改时间
     */
    @Column(name = "update_time")
    private Date updateTime;

    /**
     * 报价单流转状态（码表quotation_status）
     */
    @Column(name = "quotation_status")
    private String quotationStatus;

    /**
     * 注意事项
     */
    @Column(name = "quotation_note")
    private String quotationNote;

    /**
     * 发件人
     */
    @Column(name = "quotation_from")
    private String quotationFrom;

    /**
     * 回复
     */
    @Column(name = "quotation_re")
    private String quotationRe;

    /**
     * 前言
     */
    @Column(name = "quotation_message")
    private String quotationMessage;

    /**
     * 报价单号
     */
    @Column(name = "quotation_no")
    private String quotationNo;

    /**
     * 备注
     */
    @Column(name = "quotation_remark")
    private String quotationRemark;

    /**
     * 客户是否签回（码表quotation_sign_back）
     */
    @Column(name = "customer_sign_back")
    private String customerSignBack;

    /**
     * 主管
     */
    private String manager;

    /**
     * 经办人
     */
    private String handler;

    /**
     * 业务员
     */
    private String salesman;

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "quotation";
    }
}