package com.huigou.topsun.proofing.domain.vo;


import lombok.Data;

import javax.persistence.Column;
import java.util.Date;

/**
 * 样品制作表展示
 * 含ProofingMakeBaseInfo、ProofingMakeLooked、ProofingMakePdPublishedConf
 */
@Data
public class ProofingMakeVo{

    /**
     * 制作单id
     */
    private String proofingMakeId;

    /**
     * 制作单号
     */

    private String proofingMakeNo;

    /**
     * 打样申请单id
     */

    private String proofingApplyId;

    /**
     * 申请单号
     */

    private String proofingApplyNo;

    /**
     * 产品Id
     */

    private String productId;
    /**
     * 产品编号
     */

    private String productCode;

    /**
     * 品牌客户编号
     */

    private String customerCode;

    /**
     * 版面
     */
    private String page;

    /**
     * 版面需求时间
     */

    private Date proofingMakePageNeedTime;

    /**
     * 完成日期
     */

    private Date proofingMakeCompleteDate;

    /**
     * 样品中文名称
     */

    private String proofingMakeSampleCnName;

    /**
     * 样品英文名称
     */

    private String proofingMakeSampleEnName;

    /**
     * 样品版次
     */

    private Integer proofingMakeSampleVersion;

    /**
     * 样品规格
     */

    private Integer proofingMakeSampleSize;

    /**
     * 样品款式
     */

    private String sampleStyle;

    /**
     * 样品数量
     */

    private Long proofingMakeSampleNum;

    /**
     * 产量情况
     */

    private String proofingMakeOutputSituation;

    /**
     * 产品代号
     */

    private String proofingMakeProductNo;

    /**
     * 产品类别名称
     */
    private String productCategoryName;

    /**
     * 打样形式
     */

    private String proofingType;

    /**
     * 分配方式
     */

    private String proofingMakeAllocationType;

    /**
     * 表面处理
     */

    private String proofingMakeSurfaceTreatment;

    /**
     * NG重新打样原因
     */

    private String proofingMakeNgReReason;

    /**
     * 申请单状态
     */

    private String proofingApplyApplicationStatus;

    /**
     * 测试标准
     */

    private String proofingMakeTestStandard;

    /**
     * 颜色种类
     */

    private String colorType;

    /**
     * 专
     */
    private String expert;

    /**
     * 网版目数
     */

    private Integer printingPlateNum;

    /**
     * 啤板模数
     */

    private Integer beerPlateNum;

    /**
     * 模切板模数
     */

    private Integer dieBoardNum;

    /**
     * 标准色号
     */

    private String standardColor;


    private String proofingMakeLookedId;



    /**
     * 是否量产
     */

    private String isOutput;

    /**
     * 是否外发
     */

    private String isOut;

    /**
     * 是否改变
     */

    private String isChange;

    /**
     * 塑胶袋结构
     */

    private String plasticBagStructure;

    /**
     * 长;单位cm
     */

    private Double productLength;

    /**
     * 宽;单位cm
     */

    private Double productWidth;

    /**
     * 高;单位cm
     *
     */
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    private Double productThick;

    /**
     * 单层厚(单位丝)
     */
    private Integer productSingleLayer;

    /**
     * 层数
     */
    private Integer productLayerNum;

    /**
     * 样品形状
     */
    private String sampleShape;

    /**
     * 样品形状大小
     */
    private Double sampleShapeSize;

    /**
     * 预定工序流程id
     */
    private String plannedFlowId;

    /**
     * 文件存储位置
     */
    private String fileStorageLocation;

    /**
     * 样品物料
     */
    private String sampleMaterial;

    /**
     * 成品克重;单位g
     */
    private Double productWeight;

    /**
     * 孔径(单位mm)
     */
    private Double productAperture;

    /**
     * 单重(单位KG)
     */
    private Double productSingleWeight;

    /**
     * 样品制作单状态
     */
    private String proofingMakeStatus;

    /**
     * 是否确认
     */
    private String isConfirm;

    /**
     * 打样制作单排版参数id
     */

    private String proofingMakePdPublishedConfId;

    /**
     * 模数
     */
    private Integer modulus;

    /**
     * 行数
     */

    private Integer rowNum;

    /**
     * 列数
     */

    private Integer columnNum;

    /**
     * 搭版数
     */

    private Integer contactNum;

    /**
     * 行双刀位(单位mm)
     */

    private Double rowDoubleBlade;

    /**
     * 列双刀位(单位mm)
     */

    private Double columnDoubleBlade;

    /**
     * 派工倍数
     */

    private Integer dispatchMultiple;

    /**
     * 印张长度(单位cm)
     */

    private Double sheetLength;

    /**
     * 印张宽度(单位cm)
     */

    private Double sheetWidth;

    /**
     * 印刷正面颜色
     */
    private String printFrontColer;

    /**
     * 印刷反面颜色
     */
    private String printOppositeColor;
}