package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author Tison
 * 产品外观
 */
@Entity
@Table(name = "product_looked")
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductLooked implements Serializable {

	/**
	 * 产品外观ID
	 */
	@Id
	@Column(name = "product_looked_id", nullable = false, length = 32)
	@JsonSerialize(using = NumberToStringSerializer.class)
	private BigDecimal productLookedId;

	/**
	 * 产品ID
	 */
	@Column(name = "product_id", nullable = true, length = 32)
	@JsonSerialize(using = NumberToStringSerializer.class)
	private BigDecimal productId;

	/**
	 * 长;单位cm
	 */
	@Column(name = "product_length", nullable = true)
	private Double productLength;

	/**
	 * 宽;单位cm
	 */
	@Column(name = "product_width", nullable = true)
	private Double productWidth;

	/**
	 * 高;单位cm
	 */
	@Column(name = "product_height", nullable = true)
	private Double productHeight;

	/**
	 * 厚度;单位mm
	 */
	@Column(name = "product_thick", nullable = true)
	private Double productThick;

	/**
	 * 成品克重;单位g
	 */
	@Column(name = "product_weight", nullable = true)
	private Double productWeight;

	/**
	 * 角型
	 */
	@Column(name = "product_angle_type", nullable = true, length = 32)
	private String productAngleType;

	/**
	 * 角度(单位mm)
	 */
	@Column(name = "product_angle", nullable = true)
	private Double productAngle;

	/**
	 * 孔径(单位mm)
	 */
	@Column(name = "product_aperture", nullable = true)
	private Double productAperture;

	/**
	 * 单层厚(单位丝)
	 */
	@Column(name = "product_single_layer", nullable = true)
	private Integer productSingleLayer;

	/**
	 * 单重(单位KG)
	 */
	@Column(name = "product_single_weight", nullable = true)
	private Double productSingleWeight;

	/**
	 * 层数
	 */
	@Column(name = "product_layer_num", nullable = true)
	private Integer productLayerNum;

	/**
	 * 是否防霉(is_open)
	 */
	@Column(name = "product_mould", nullable = true, length = 32)
	private String productMould;

	/**
	 * 是否写码(is_open)
	 */
	@Column(name = "product_coding", nullable = true, length = 32)
	private String productCoding;

	/**
	 * 体系认证(product_sys_certification)
	 */
	@Column(name = "product_sys_certification", nullable = true, length = 32)
	private String productSysCertification;

	/**
	 * 仓库(store_name)
	 */
	@Column(name = "store_name", nullable = true, length = 32)
	private String storeName;

	/**
	 * 采购单位(product_buy_unit)
	 */
	@Column(name = "product_buy_unit", nullable = true, length = 32)
	private String productBuyUnit;

	/**
	 * 样品形状：RIGHT-直角；ALLOTYPE-异型；FILLET-圆角；
	 */
	@Column(name = "product_shape", nullable = true, length = 50)
	private String productShape;

	/**
	 * 样品形状大小（mm）
	 */
	@Column(name = "prodcut_shape_size", nullable = true, length = 102)
	private Double prodcutShapeSize;

	/**
	 * 采购换算值
	 */
	@Column(name = "purchase_conversion_value", nullable = true)
	private Double purchaseConversionValue;

	/**
	 * 系数
	 */
	@Column(name = "coefficient", nullable = true)
	private Double coefficient;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		ProductLooked looked = (ProductLooked) o;
		return Objects.equals(productLookedId, looked.productLookedId) && Objects.equals(productId, looked.productId) && Objects.equals(productLength, looked.productLength) && Objects.equals(productWidth, looked.productWidth) && Objects.equals(productHeight, looked.productHeight) && Objects.equals(productThick, looked.productThick) && Objects.equals(productWeight, looked.productWeight) && Objects.equals(productAngleType, looked.productAngleType) && Objects.equals(productAngle, looked.productAngle) && Objects.equals(productAperture, looked.productAperture) && Objects.equals(productSingleLayer, looked.productSingleLayer) && Objects.equals(productSingleWeight, looked.productSingleWeight) && Objects.equals(productLayerNum, looked.productLayerNum) && Objects.equals(productMould, looked.productMould) && Objects.equals(productCoding, looked.productCoding) && Objects.equals(productSysCertification, looked.productSysCertification) && Objects.equals(storeName, looked.storeName) && Objects.equals(productBuyUnit, looked.productBuyUnit) && Objects.equals(productShape, looked.productShape) && Objects.equals(prodcutShapeSize, looked.prodcutShapeSize) && Objects.equals(purchaseConversionValue, looked.purchaseConversionValue) && Objects.equals(coefficient, looked.coefficient);
	}

	@Override
	public int hashCode() {
		return Objects.hash(productLookedId, productId, productLength, productWidth, productHeight, productThick, productWeight, productAngleType, productAngle, productAperture, productSingleLayer, productSingleWeight, productLayerNum, productMould, productCoding, productSysCertification, storeName, productBuyUnit, productShape, prodcutShapeSize, purchaseConversionValue, coefficient);
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.toString();
	}

	public BigDecimal getProductLookedId() { return productLookedId; }

	public void setProductLookedId(String productLookedId) {
		this.productLookedId = (productLookedId != null) ? new BigDecimal(productLookedId) : null;
	}


	public BigDecimal getProductId() { return productId; }

	public void setProductId(String productId) {
		this.productId = (productId != null) ? new BigDecimal(productId) : null;
	}

	public Double getProductLength() {
		return this.productLength;
	}
	
	public void setProductLength(Double productLength) {
		this.productLength = productLength;
	}
	
	public Double getProductWidth() {
		return this.productWidth;
	}
	
	public void setProductWidth(Double productWidth) {
		this.productWidth = productWidth;
	}
	
	public Double getProductHeight() {
		return this.productHeight;
	}
	
	public void setProductHeight(Double productHeight) {
		this.productHeight = productHeight;
	}
	
	public Double getProductThick() {
		return this.productThick;
	}
	
	public void setProductThick(Double productThick) {
		this.productThick = productThick;
	}
	
	public Double getProductWeight() {
		return this.productWeight;
	}
	
	public void setProductWeight(Double productWeight) {
		this.productWeight = productWeight;
	}
	
	public String getProductAngleType() {
		return this.productAngleType;
	}
	
	public void setProductAngleType(String productAngleType) {
		this.productAngleType = productAngleType;
	}
	
	public Double getProductAngle() {
		return this.productAngle;
	}
	
	public void setProductAngle(Double productAngle) {
		this.productAngle = productAngle;
	}
	
	public Double getProductAperture() {
		return this.productAperture;
	}
	
	public void setProductAperture(Double productAperture) {
		this.productAperture = productAperture;
	}
	
	public Integer getProductSingleLayer() {
		return this.productSingleLayer;
	}
	
	public void setProductSingleLayer(Integer productSingleLayer) {
		this.productSingleLayer = productSingleLayer;
	}
	
	public Double getProductSingleWeight() {
		return this.productSingleWeight;
	}
	
	public void setProductSingleWeight(Double productSingleWeight) {
		this.productSingleWeight = productSingleWeight;
	}
	
	public Integer getProductLayerNum() {
		return this.productLayerNum;
	}
	
	public void setProductLayerNum(Integer productLayerNum) {
		this.productLayerNum = productLayerNum;
	}
	
	public String getProductMould() {
		return this.productMould;
	}
	
	public void setProductMould(String productMould) {
		this.productMould = productMould;
	}
	
	public String getProductCoding() {
		return this.productCoding;
	}
	
	public void setProductCoding(String productCoding) {
		this.productCoding = productCoding;
	}
	
	public String getProductSysCertification() {
		return this.productSysCertification;
	}
	
	public void setProductSysCertification(String productSysCertification) {
		this.productSysCertification = productSysCertification;
	}
	
	public String getStoreName() {
		return this.storeName;
	}
	
	public void setStoreName(String storeName) {
		this.storeName = storeName;
	}
	
	public String getProductBuyUnit() {
		return this.productBuyUnit;
	}
	
	public void setProductBuyUnit(String productBuyUnit) {
		this.productBuyUnit = productBuyUnit;
	}
	
	public String getProductShape() {
		return this.productShape;
	}
	
	public void setProductShape(String productShape) {
		this.productShape = productShape;
	}
	
	public Double getProdcutShapeSize() {
		return this.prodcutShapeSize;
	}
	
	public void setProdcutShapeSize(Double prodcutShapeSize) {
		this.prodcutShapeSize = prodcutShapeSize;
	}
	
	public Double getPurchaseConversionValue() {
		return this.purchaseConversionValue;
	}
	
	public void setPurchaseConversionValue(Double purchaseConversionValue) {
		this.purchaseConversionValue = purchaseConversionValue;
	}
	
	public Double getCoefficient() {
		return this.coefficient;
	}
	
	public void setCoefficient(Double coefficient) {
		this.coefficient = coefficient;
	}
}
