var gridManager = null, refreshFlag = false,OrgRootId = 0,columnData = null;
$(document).ready(function() {
    initializeUI();
    initializeGrid();
});

function initializeUI(){
    UICtrl.layout("#layoutDiv",{leftWidth:2});
    $('#maintree').commonTree({
        loadTreesAction:'resource/findResourceTypes.ajax',
        parentId :OrgRootId,
        getParam : function(e){
            return {showDisabledOrg:0,displayableOrgKinds : "ogn"};
        },
        changeNodeIcon:function(data){
            data[this.options.iconFieldName]= OpmUtil.getOrgImgUrl(data.orgKindId, data.status);
        },
        IsShowMenu:false,
        IsShowFieldMenu:true,
        onClick : function(data){
            var html=[];
            html.push('<span class="tomato-color">[',data.name,']</span>');
            $('#layoutDiv').layout('setCenterTitle',html.join(''));
            // 创建表格
            var table = document.getElementById("maingrid");
            var thead = table.querySelector("thead tr");
            $("#resourceTypeId").val(data.resourceTypeId);
            getFieldAndTitle(data.resourceTypeId);
        }
    });
}

//初始化表格
function initializeGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        updateHandler: function(){
            updateHandler();
        },
        deleteHandler: deleteHandler
    });

    gridManager = UICtrl.grid('#maingrid', {
        //columns: columnData,
        dataAction : 'server',
        url: web_app.name+'/resourceField/getResourceFieldValueList.ajax',
        parms: {resourceTypeId: $("#resourceTypeId").val()},
        checkbox: true,
        width : '100%',
        height : '100%',
        heightDiff : -5,
        sortName:'code',
        sortOrder:'asc',
        toolbar: toolbarOptions,
        onDblClickRow : function(data, rowindex, rowobj) {
            updateHandler(data.id);
        }
    });
    $('#maingrid').on('click',function(e){
        var $clicked = $(e.target || e.srcElement);
        if($clicked.is('a.budgetFrozen')){//报销授权
            showBudgetFrozen($clicked.data('code'));
            return false;
        }
        if($clicked.is('a.budgetLog')){//报销授权查询
            showBudgetLog($clicked.data('code'));
            return false;
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

// 查询
function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

//刷新表格
function reloadGrid() {
    gridManager.loadData();
}

//重置表单
function resetForm(obj) {
    $(obj).formClean();
}

//关闭对话框
function dialogClose(){
    if(refreshFlag){
        reloadGrid();
        refreshFlag=false;
    }
}

//添加按钮
function addHandler() {
    var resourceTypeId=$('#resourceTypeId').val();
    if (Public.isBlank(resourceTypeId)) {
        Public.tip('请选择资源！');
        return;
    }
    UICtrl.showAjaxDialog({
        title: $.i18nProp('资源值'),
        url : web_app.name + '/resourceField/forwardAddResourceFieldValue.load',
        //init:initDetailDialog,
        param:{resourceTypeId:resourceTypeId},
        ok : insert,
        width : 600,
        close : dialogClose
    });
}

//新增保存
function insert() {
    var _self=this;
    $('#submitForm').ajaxSubmit({
        url : web_app.name + '/resourceField/saveResourceFiledValue.ajax',
        param:{},
        success : function(data) {
            if (data == "1"){
                Public.successTip("保存成功！");
            }
            _self.close();
            reloadGrid();
        }
    });
}

//编辑按钮
function updateHandler(id) {
    if (!id) {
        id = DataUtil.getUpdateRowId(gridManager);
        if (!id) {
            return;
        }
    }
    UICtrl.showAjaxDialog({
        title: $.i18nProp('资源值'),
        width: 600,
        url: web_app.name + '/resourceField/forwardAddResourceFieldValue.load',
        param: {id: id,resourceTypeId: $('#resourceTypeId').val()},
        ok: update,
        close:dialogClose
    });
}

//编辑保存
function update() {
    var _self=this;
    $('#submitForm').ajaxSubmit({
        url : web_app.name + '/resourceField/updateResourceFiledValue.ajax',
        success : function(data) {
            if (data == "1"){
                Public.successTip("修改成功！");
            }
            refreshFlag = true;
            _self.close();
            reloadGrid();
        }
    });
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'resourceField/deleteResourceFiledValue.ajax',
        param:{
            id:DataUtil.getUpdateRowId(gridManager),
            resourceTypeId: $('#resourceTypeId').val()
        },
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function (data) {
            if (data == "1"){
                Public.successTip("删除成功！");
            }
            reloadGrid();
        }
    });
}

function getFieldAndTitle(resourceTypeId){
    Public.ajax(web_app.name + '/resourceField/getResourceField.ajax?resourceTypeId='+resourceTypeId
        , {}
        , function (data) {
            // 动态生成列配置
            columnData = data.map(function (column) {
                return {
                    name: column.resourceFieldName,
                    display: column.resourceFiledTitle,
                    sorting: true, // 如果需要启用排序
                };
            });
            gridManager=UICtrl.getGridManager('#maingrid');
            UICtrl.reRenderGridColumns(gridManager,columnData);
            UICtrl.gridSearch(gridManager,{resourceTypeId:$("#resourceTypeId").val()});
        });
}

