package com.huigou.topsun.sap.purchase.controller;

import com.huigou.topsun.sap.purchase.application.SapPurchaseItemApplication;
import com.huigou.topsun.sap.purchase.domain.SapPurchaseItem;
import com.huigou.topsun.sap.purchase.domain.query.SapPurchaseItemQueryRequest;
import com.huigou.topsun.sap.purchase.repository.SapPurchaseItemRepository;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/27/17:24
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseItem")
public class SapPurchaseItemController extends CommonController {
    @Resource
    private SapPurchaseItemApplication sapPurchaseItemApplication;
    @Resource
    private SapPurchaseItemRepository sapPurchaseItemRepository;

    public String querySapPurchaseItems(){
        SDO sdo = this.getSDO();
        SapPurchaseItemQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseItemQueryRequest.class);
        Map<String, Object> map = sapPurchaseItemApplication.querySapPurchaseItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapPurchaseItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapPurchaseItemApplication.deleteByIds(ids);
        return success();
    }

/*    @SkipAuth
    public String test(){
        SDO sdo = this.getSDO();
        String bsart = sdo.getString("bsart");
        List<SapPurchaseItem> bySapPurchaseBsart = sapPurchaseItemRepository.findBySapPurchase_bsart(bsart);
        return toResult(bySapPurchaseBsart);
    }*/
}
