package com.huigou.topsun.sap.purchase.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.demo.application.LeaveApplication;
import com.huigou.topsun.demo.domain.model.Leave;
import com.huigou.topsun.sap.purchase.application.SapPurchaseApplication;
import com.huigou.topsun.sap.purchase.domain.SapPurchase;
import com.huigou.topsun.sap.purchase.domain.query.SapPurchaseQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/27/10:21
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchase")
public class SapPurchaseController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/purchase/";
    }

    @Resource
    private SapPurchaseApplication sapPurchaseApplication;

    public String forwardSapPurchaseList(){
        return forward("sapPurchaseList");
    }

    public String slicedSapPurchaseList(){
        SDO sdo = this.getSDO();
        SapPurchaseQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseQueryRequest.class);
        Map<String, Object> map = sapPurchaseApplication.slicedSapPurchaseList(queryRequest);
        return toResult(map);
    }

    public String forwardSapPurchaseDetail(){
        this.putAttribute("processDefinitionKey", SapPurchaseApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapPurchase sapPurchase = new SapPurchase();
        sapPurchase.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPurchase.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("sapPurchaseDetail",sapPurchase);
    }

    public String showSapPurchaseDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPurchase sapPurchase = sapPurchaseApplication.loadSapPurchase(id);
        return forward("sapPurchaseDetail",sapPurchase);
    }

}
