package com.huigou.topsun.sap.priceMasterData.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/27
 * description:
 */
@JsonIgnoreProperties
public class SapPriceMasterDataReturnVo implements Serializable{

    /**
     * 单据编号
     */
    @JsonProperty("bill_code")
    private String billCode;
    /**
     * 申请人员名称
     */
    @JsonProperty("person_member_name")
    private String personMemberName;
    /**
     * 申请部门名称
     */
    @JsonProperty("dept_name")
    private String deptName;

    /**
     * 申请日期
     */
    @JsonProperty("fillin_date")
    private Date fillinDate;

    /**
     * 联系方式
     */
    @JsonProperty("tele_phone")
    private String telePhone;

    /**
     * KSCHL-条件类型(可选)
     * 通过选择相应的条件类型维护不同的价格
     * PR01-工厂价格；
     * ZPR1-品牌价格
     */
    @JsonProperty(value = "KSCHL", required = true)
    private String KSCHL;

    /**
     * VKORG-销售组织(可选)
     * 目前只能选择1000-广州科技销售组织，其它销售组织隐藏
     * 1000-广州科技销售组织；
     * 2000-广州金库销售组织；
     */
    @JsonProperty(value = "VKORG", required = true)
    private String VKORG;

    /**
     * VTWEG-分销渠道(可选)
     * 10-内销；
     * 20-外销；
     * 80-集团内
     */
    @JsonProperty(value = "VTWEG", required = true)
    private String VTWEG;

    /**
     * KUNNR-客户(可选)
     * 通过调用客户主数据查询接口，搜索到相应的客户编号与描述
     */
    @JsonProperty(value = "KUNNR", required = true)
    private String KUNNR;

    /**
     * MATNR-产品物料(可选)
     */
    @JsonProperty(value = "MATNR", required = true)
    private String MATNR;

    /**
     * KBETR-价格(必输)
     */
    @JsonProperty("KBETR")
    private BigDecimal KBETR;

    /**
     * 币别(必输)
     */
    @JsonProperty("KONWA")
    private String KONWA;

    /**
     * 条件单位(必输)
     */
    @JsonProperty("KMEIN")
    private String KMEIN;

    /**
     * 有效期自(必输)
     */
    @JsonProperty("DATAB")
    @JsonFormat(pattern = "yyyyMMdd", timezone = "GTM-8")
    private Date DATAB;
    /**
     * 有效期至(必输)
     */
    @JsonProperty("DATBI")
    @JsonFormat(pattern = "yyyyMMdd", timezone = "GTM-8")
    private Date DATBI;

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public void setPersonMemberName(String personMemberName) {
        this.personMemberName = personMemberName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public void setFillinDate(Date fillinDate) {
        this.fillinDate = fillinDate;
    }

    public void setTelePhone(String telePhone) {
        this.telePhone = telePhone;
    }

    public void setKSCHL(String KSCHL) {
        this.KSCHL = KSCHL;
    }

    public void setVKORG(String VKORG) {
        this.VKORG = VKORG;
    }

    public void setVTWEG(String VTWEG) {
        this.VTWEG = VTWEG;
    }

    public void setKUNNR(String KUNNR) {
        this.KUNNR = KUNNR;
    }

    public void setMATNR(String MATNR) {
        this.MATNR = MATNR;
    }

    public void setKBETR(BigDecimal KBETR) {
        this.KBETR = KBETR;
    }

    public void setKONWA(String KONWA) {
        this.KONWA = KONWA;
    }

    public void setKMEIN(String KMEIN) {
        this.KMEIN = KMEIN;
    }

    public void setDATAB(Date DATAB) {
        this.DATAB = DATAB;
    }

    public void setDATBI(Date DATBI) {
        this.DATBI = DATBI;
    }
}
