package com.huigou.topsun.sap.priceMasterData.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/27
 * description:
 */
@Data
@Entity
@Table(name = "sap_price_master_data_item")
public class SapPriceMasterDataItem implements Serializable {
    /**
     * id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 所属价格主数据id
     */
    @Column(name = "price_master_data_id")
    private String priceMasterDataId;
    /**
     * MATNR-产品物料(可选)
     * 通过调用物料主数据查询接口，搜索到相应的物料主数据编号与描述
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * KBETR-价格(必输)
     * 手工输入
     * 11位长度，6位小数点
     */
    @Column(name = "KBETR")
    private BigDecimal kbetr;

    /**
     * 币别(必输)
     */
    @Column(name = "KONWA")
    private String konwa;

    /**
     * 条件单位(必输)
     * 通过数据字典的形式存储基本计量单位
     */
    @Column(name = "KMEIN")
    private String kmein;

    /**
     * 有效期自(必输)
     */
    @Column(name = "DATAB")
    private Date datab;

    /**
     * 有效期至(必输)
     */
    @Column(name = "DATBI")
    private Date datbi;

    /**
     * 行号
     */
    @Column(name = "sequence")
    private String sequence;
}
