package com.huigou.topsun.sap.nonProdApply.controller;


import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Controller
@ControllerMapping("/sapNonProdApply")
public class NonProdApplyController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/nonProdApply/";
    }

    @Autowired
    NonProdApplyApplication nonProdApplyApplication;



    public static String generateApplicationNo() {
        String dateStamp =getCurrentDate("yyyyMMdd");
        // 生成10位随机数
        String randomNumber = String.format("%010d", (int) (Math.random() * 10000000000L));
        // 组合申请单编号
        String applicationNumber = dateStamp + "-" + "M" + "-" + randomNumber;
        return applicationNumber;
    }

    public static String getCurrentDate(String format) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String formattedDate = dateFormat.format(date);
        return formattedDate;
    }

    public String forwardNonProdApplyList(){
        return forward("nonProdApplyList");
    }

    public String forwardNonProdApplyDetail(){
        this.putAttribute("processDefinitionKey", NonProdApplyApplication.PROCESS_DEFINITION_KEY);
        this.putAttribute("procUnitId", "Apply");//定义流程环节的id
        NonProdApplyBaseInfo nonProdApplyBaseInfo = new NonProdApplyBaseInfo();
        nonProdApplyBaseInfo.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        nonProdApplyBaseInfo.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        this.putAttribute("applicationNo",generateApplicationNo());
        this.putAttribute("applicationDate",getCurrentDate("yyyy/MM/dd"));
        return forward("nonProdApplyDetail",nonProdApplyBaseInfo);
    }

    public String slicedNonProdApplyList(){
        SDO sdo = this.getSDO();
        NonProdApplyBaseInfoQueryRequest queryRequest = sdo.toQueryRequest(NonProdApplyBaseInfoQueryRequest.class);
        Map<String, Object> map = nonProdApplyApplication.slicedNonProdApplyBaseInfoQuery(queryRequest);
        return toResult(map);
    }


    /**
     * 工作流审核跳转页面
     * @return
     */
    public String showNonProdApply() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyApplication.loadNonProdApplyBaseInfoById(id);
        return forward("statsIndicators", nonProdApplyBaseInfo);
    }

    public String deleteNonProdApply(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        nonProdApplyApplication.deleteNonProdApplyBaseInfoByIds(ids);
        return success();
    }

}