package com.huigou.topsun.sap.fixedAssets.domain.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * title:
 * author:ZHT
 * date:2023/12/29
 * description:
 */
@JsonIgnoreProperties
public class SapFixedAssetsReturnVo implements Serializable {

    /**
     * BPM单号
     */
    @JsonProperty("ZBPMN")
    private String zbpmn;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    @JsonProperty("ZFLG")
    private Integer zflg;

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @JsonProperty(value = "ANLN1",required = true)
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @JsonProperty(value = "ANLKL",required = true)
    private String anlkl;

    /**
     * 公司代码（必填）
     */
    @JsonProperty("BUKRS")
    private String bukrs;

    /**
     * 文本（必填）
     */
    @JsonProperty("TXT50")
    private String txt50;

    /**
     * 存货号；存放地点
     */
    @JsonProperty(value = "INVNR",required = true)
    private String invnr;

    /**
     * 数量
     */
    @JsonProperty(value = "MENGE",required = true)
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @JsonProperty(value = "MEINS",required = true)
    private String meins;

    /**
     * 成本中心（必填）
     */
    @JsonProperty("KOSTL")
    private String kostl;

    /**
     * 责任成本中心
     */
    @JsonProperty(value = "KOSTLV",required = true)
    private String kostlv;

    public String getZbpmn() {
        return zbpmn;
    }

    public void setZbpmn(String zbpmn) {
        this.zbpmn = zbpmn;
    }

    public Integer getZflg() {
        return zflg;
    }

    public void setZflg(Integer zflg) {
        this.zflg = zflg;
    }

    public String getAnln1() {
        return anln1;
    }

    public void setAnln1(String anln1) {
        this.anln1 = anln1;
    }

    public String getAnlkl() {
        return anlkl;
    }

    public void setAnlkl(String anlkl) {
        this.anlkl = anlkl;
    }

    public String getBukrs() {
        return bukrs;
    }

    public void setBukrs(String bukrs) {
        this.bukrs = bukrs;
    }

    public String getTxt50() {
        return txt50;
    }

    public void setTxt50(String txt50) {
        this.txt50 = txt50;
    }

    public String getInvnr() {
        return invnr;
    }

    public void setInvnr(String invnr) {
        this.invnr = invnr;
    }

    public BigDecimal getMenge() {
        return menge;
    }

    public void setMenge(BigDecimal menge) {
        this.menge = menge;
    }

    public String getMeins() {
        return meins;
    }

    public void setMeins(String meins) {
        this.meins = meins;
    }

    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        this.kostl = kostl;
    }

    public String getKostlv() {
        return kostlv;
    }

    public void setKostlv(String kostlv) {
        this.kostlv = kostlv;
    }
}
