package com.huigou.topsun.sap.fixedAssets.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/21
 * description:
 */
@Data
public class SapFixedAssetsQueryRequest extends QueryAbstractRequest {

    private String id;

    private Long version;
    /**
     * BPM单号
     */
    private String zbpmn;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    private Integer zflg;

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    private String anlkl;

    /**
     * 公司代码（必填）
     */
    private String bukrs;

    /**
     * 文本（必填）
     */
    private String txt50;

    /**
     * 存货号；存放地点
     */
    private String invnr;

    /**
     * 数量
     */
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    private String meins;

    /**
     * 成本中心（必填）
     */
    private String kostl;

    /**
     * 责任成本中心
     */
    private String kostlv;

    private Date fillinDate;

    private String billCode;

    private Integer statusId;

    private String fullId;

    private String organId;

    private String organName;

    private String deptId;

    private String deptName;

    private String positionId;

    private String positionName;

    private String personMemberId;

    private String personMemberName;
}
