package com.huigou.topsun.resource.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 资源分类
 * @TableName resource_type
 */
//@Schema(description = "资源类型")
@TableName(value ="resource_type")
@Data
public class ResourceType implements Serializable {
    /**
     * 资源库类型ID
     */
    //@Schema(description = "资源库类型ID")
    @TableId(value = "resource_type_id")
    private String resourceTypeId;

    /**
     * 资源库类型表名
     */
    //@Schema(description = "资源库类型表名")
    @TableField(value = "resource_table_name")
    private String resourceTableName;

    /**
     * 资源库类型表名称
     */
    //@Schema(description = "资源库类型表名称")
    @TableField(value = "resource_table_title")
    private String resourceTableTitle;

    /**
     * 父类表名
     */
    //@Schema(description = "父类表名")
    @TableField(value = "parent_table_name")
    private String parentTableName;

    /**
     * 父类显示名
     */
    //@Schema(description = "父类显示名")
    @TableField(value = "parent_table_title")
    private String parentTableTitle;

    /**
     * 超类名
     */
    //@Schema(description = "超类表名")
    @TableField(value = "super_table_name")
    private String superTableName;

    /**
     * 超类显示名
     */
    //@Schema(description = "超类显示名")
    @TableField(value = "super_table_title")
    private String superTableTitle;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}