package com.huigou.topsun.resource.controller;

import com.huigou.topsun.resource.service.ResourceFiledService;
import com.huigou.topsun.resource.vo.ResourceFiledVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/10/31/9:07
 * @Description:
 */
//@Tag(name = "资源字段")
@Controller
@ControllerMapping("/resourceField")
public class ResourceFieldController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/resource/";
    }
    @Resource
    private ResourceFiledService resourceFiledService;

    /**
     * 跳转到新增/修改资源值的页面
     * @return
     */
    public String forwardAddResourceFieldValue(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String resourceTypeId = sdo.getString("resourceTypeId");
        this.putAttribute("resourceTypeId",resourceTypeId);
        List<ResourceFiledVo> resourceFiledVos = resourceFiledService.findFieldValueByResourceTypeIdAndId(resourceTypeId, id);
        this.putAttribute("resourceFiledVos",resourceFiledVos);
        return forward("fieldValueDetail");
    }

    //@Operation(summary = "")

    /**
     * 根据资源类型id，查询资源字段
     * @return
     */
    public String getResourceField(){
        SDO sdo = this.getSDO();
        String resourceTypeId = sdo.getString("resourceTypeId");
        return toResult(resourceFiledService.findByResourceTypeId(resourceTypeId));
    }

    /**
     * 根据资源类型id和资源值id查询资源
     * @return
     */
    public String getResourceFieldValue(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String resourceTypeId = sdo.getString("resourceTypeId");
        List<ResourceFiledVo> resourceFiledVos = resourceFiledService.findFieldValueByResourceTypeIdAndId(resourceTypeId, id);
        return toResult(resourceFiledVos);
    }

    //@Operation(summary = "保存资源字段值")
    public String saveResourceFiledValue(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = sdo.getProperties();
        return toResult(resourceFiledService.saveResourceFiledValue(map));
    }

    //@Operation(summary = "修改资源字段值")
    public String updateResourceFiledValue(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = sdo.getProperties();
        return toResult(resourceFiledService.saveResourceFiledValue(map));
    }

    //@Operation(summary = "根据资源类型id，获取资源值")
    public String getResourceFieldValueList(){
        SDO sdo = this.getSDO();
        String resourceTypeId = sdo.getString("resourceTypeId");
        List<Map<String, Object>> resourceFieldValue = null;
        if (StringUtil.isBlank(resourceTypeId)){
            resourceFieldValue = new ArrayList<>();
        }else {
            resourceFieldValue = resourceFiledService.getResourceFieldValueList(resourceTypeId);
        }
        HashMap<Object, Object> map = new HashMap<>();
        map.put("Rows",resourceFieldValue);
        return toResult(map);
    }

    //@Operation(summary = "根据资源类型id和数据id删除资源值")
    public String deleteResourceFiledValue(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        String resourceTypeId = sdo.getString("resourceTypeId");
        return toResult(resourceFiledService.deleteResourceFieldValue(resourceTypeId,id));
    }

    public String getResourceFieldType(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        return toResult(resourceFiledService.findById(id));
    }
}
