package com.huigou.topsun.quotation.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户报价规则
 * @TableName customer_quotation_rule
 */
@Table(name="customer_quotation_rule")
@Data
@Entity
public class CustomerQuotationRule implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_quotation_rule_id")
    private String customerQuotationRuleId;

    /**
     * 客户id
     */
    @Column(name = "customer_manager_id")
    private String customerManagerId;

    /**
     * 报价规则描述
     */
    @Column(name = "rule_des")
    private String ruleDes;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        CustomerQuotationRule other = (CustomerQuotationRule) that;
        return (this.getCustomerQuotationRuleId() == null ? other.getCustomerQuotationRuleId() == null : this.getCustomerQuotationRuleId().equals(other.getCustomerQuotationRuleId()))
            && (this.getCustomerManagerId() == null ? other.getCustomerManagerId() == null : this.getCustomerManagerId().equals(other.getCustomerManagerId()))
            && (this.getRuleDes() == null ? other.getRuleDes() == null : this.getRuleDes().equals(other.getRuleDes()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getCustomerQuotationRuleId() == null) ? 0 : getCustomerQuotationRuleId().hashCode());
        result = prime * result + ((getCustomerManagerId() == null) ? 0 : getCustomerManagerId().hashCode());
        result = prime * result + ((getRuleDes() == null) ? 0 : getRuleDes().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", customerQuotationRuleId=").append(customerQuotationRuleId);
        sb.append(", customerManagerId=").append(customerManagerId);
        sb.append(", ruleDes=").append(ruleDes);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}