package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品排版配置ID
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_typeset_conf")
public class ProductTypesetConf implements Serializable {

	/**
	 * 产品排版配置ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_typeset_conf_id", nullable = false)
	private BigDecimal productTypesetConfId;

	/**
	 * 产品ID
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 印张长度(单位cm)
	 */
	@Column(name = "length", nullable = true)
	private Double length;

	/**
	 * 印张宽度(单位cm)
	 */
	@Column(name = "width", nullable = true)
	private Double width;

	/**
	 * 满排个数
	 */
	@Column(name = "number", nullable = true)
	private Integer number;

	/**
	 * 损耗百分比(单位%)
	 */
	@Column(name = "loss_rate", nullable = true)
	private Double lossRate;

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductTypesetConf that = (ProductTypesetConf) o;
		return new EqualsBuilder().append(productTypesetConfId, that.productTypesetConfId).append(productId, that.productId).append(length, that.length).append(width, that.width).append(number, that.number).append(lossRate, that.lossRate).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productTypesetConfId).append(productId).append(length).append(width).append(number).append(lossRate).toHashCode();
	}

	public BigDecimal getProductTypesetConfId() {
		return this.productTypesetConfId;
	}
	
	public void setProductTypesetConfId (String  productTypesetConfId) {
		this.productTypesetConfId = (productTypesetConfId == null) || productTypesetConfId.isEmpty() ? null : new BigDecimal(productTypesetConfId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public Double getLength() {
		return this.length;
	}
	
	public void setLength(Double length) {
		this.length = length;
	}
	
	public Double getWidth() {
		return this.width;
	}
	
	public void setWidth(Double width) {
		this.width = width;
	}
	
	public Integer getNumber() {
		return this.number;
	}
	
	public void setNumber(Integer number) {
		this.number = number;
	}
	
	public Double getLossRate() {
		return this.lossRate;
	}
	
	public void setLossRate(Double lossRate) {
		this.lossRate = lossRate;
	}
}
