package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 产品工艺
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "product_technology")
public class ProductTechnology implements Serializable {

	/**
	 * 产品工艺id
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_technology_id", nullable = false)
	private BigDecimal productTechnologyId;

	/**
	 * 产品id
	 */
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "product_id", nullable = true)
	private BigDecimal productId;

	/**
	 * 产品工艺制程
	 */
	@Column(name = "product_technology_name", nullable = true, length = 255)
	private String productTechnologyName;

	/**
	 * 产品性质
	 */
	@Column(name = "product_property", nullable = true, length = 32)
	private String productProperty;

	/**
	 * 工艺要求
	 */
	@Column(name = "product_technology_require", nullable = true, length = 32)
	private String productTechnologyRequire;

	/**
	 * 啤版编号
	 */
	@Column(name = "beer_plate_no", nullable = true, length = 32)
	private String beerPlateNo;

	/**
	 * 烫金版编号
	 */
	@Column(name = "gold_plate_no", nullable = true, length = 32)
	private String goldPlateNo;

	/**
	 * 模切版编号
	 */
	@Column(name = "die_cut_plate_no", nullable = true, length = 32)
	private String dieCutPlateNo;

	/**
	 * 铜版及树脂版编号
	 */
	@Column(name = "copperp_resin_late_no", nullable = true, length = 32)
	private String copperpResinLateNo;

	/**
	 * 网版编号
	 */
	@Column(name = "net_plate_no", nullable = true, length = 32)
	private String netPlateNo;

	/**
	 * 包装方式
	 */
	@Column(name = "package_style", nullable = true, length = 32)
	private String packageStyle;

	/**
	 * 物性测试
	 */
	@Column(name = "physical_test", nullable = true, length = 32)
	private String physicalTest;

	/**
	 * 化性测试
	 */
	@Column(name = "chemistry_test", nullable = true, length = 32)
	private String chemistryTest;

	/**
	 * 产品材质
	 */
	@Column(name = "product_material", nullable = true, length = 255)
	private String productMaterial;

	/**
	 * 塑胶袋结构
	 */
	@Column(name = "plastic_bag_structure", nullable = true, length = 255)
	private String plasticBagStructure;

	/**
	 * 铜版编号
	 */
	@Column(name = "copperp_no", nullable = true, length = 32)
	private String copperpNo;

	/**
	 * 色号卡
	 */
	@Column(name = "color_no_card", nullable = true, length = 32)
	private String colorNoCard;

	/**
	 * 模具编号
	 */
	@Column(name = "plate_no", nullable = true, length = 32)
	private String plateNo;

	/**
	 * 表面处理
	 */
	@Column(name = "surface_treatment", nullable = true, length = 32)
	private String surfaceTreatment;

	/**
	 * 产品描述
	 */
	@Column(name = "product_describe", nullable = true, length = 255)
	private String productDescribe;

	/**
	 * 产品正面
	 */
	@Column(name = "product_front", nullable = true, length = 255)
	private String productFront;

	/**
	 * 产品背面
	 */
	@Column(name = "product_opposite", nullable = true, length = 255)
	private String productOpposite;

	/**
	 * 风险描述（序号、内容、等级）
	 */
	@Column(name = "risk_description", nullable = true)
	private String riskDescription;

	/**
	 * 是否附样图
	 */
	@Column(name = "have_drawing", nullable = true, length = 10)
	private String haveDrawing;

	/**
	 * 是否要鞋图
	 */
	@Column(name = "is_shoe_picture", nullable = true, length = 10)
	private String isShoePicture;

	/**
	 * 啤板模数
	 */
	@Column(name = "beer_plate_num", nullable = true)
	private Integer beerPlateNum;

	/**
	 * 模切板模数
	 */
	@Column(name = "die_board_num", nullable = true)
	private Integer dieBoardNum;

	/**
	 * 分切方向
	 */
	@Column(name = "cut_direction", nullable = true, length = 255)
	private String cutDirection;

	/**
	 * 海关商品编码
	 */
	@Column(name = "customs_commodity_code", nullable = true, length = 255)
	private String customsCommodityCode;

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		ProductTechnology that = (ProductTechnology) o;
		return new EqualsBuilder().append(productTechnologyId, that.productTechnologyId).append(productId, that.productId).append(productTechnologyName, that.productTechnologyName).append(productProperty, that.productProperty).append(productTechnologyRequire, that.productTechnologyRequire).append(beerPlateNo, that.beerPlateNo).append(goldPlateNo, that.goldPlateNo).append(dieCutPlateNo, that.dieCutPlateNo).append(copperpResinLateNo, that.copperpResinLateNo).append(netPlateNo, that.netPlateNo).append(packageStyle, that.packageStyle).append(physicalTest, that.physicalTest).append(chemistryTest, that.chemistryTest).append(productMaterial, that.productMaterial).append(plasticBagStructure, that.plasticBagStructure).append(copperpNo, that.copperpNo).append(colorNoCard, that.colorNoCard).append(plateNo, that.plateNo).append(surfaceTreatment, that.surfaceTreatment).append(productDescribe, that.productDescribe).append(productFront, that.productFront).append(productOpposite, that.productOpposite).append(riskDescription, that.riskDescription).append(haveDrawing, that.haveDrawing).append(isShoePicture, that.isShoePicture).append(beerPlateNum, that.beerPlateNum).append(dieBoardNum, that.dieBoardNum).append(cutDirection, that.cutDirection).append(customsCommodityCode, that.customsCommodityCode).isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37).append(productTechnologyId).append(productId).append(productTechnologyName).append(productProperty).append(productTechnologyRequire).append(beerPlateNo).append(goldPlateNo).append(dieCutPlateNo).append(copperpResinLateNo).append(netPlateNo).append(packageStyle).append(physicalTest).append(chemistryTest).append(productMaterial).append(plasticBagStructure).append(copperpNo).append(colorNoCard).append(plateNo).append(surfaceTreatment).append(productDescribe).append(productFront).append(productOpposite).append(riskDescription).append(haveDrawing).append(isShoePicture).append(beerPlateNum).append(dieBoardNum).append(cutDirection).append(customsCommodityCode).toHashCode();
	}

	public BigDecimal getProductTechnologyId() {
		return this.productTechnologyId;
	}
	
	public void setProductTechnologyId (String  productTechnologyId) {
		this.productTechnologyId = (productTechnologyId == null) || productTechnologyId.isEmpty() ? null : new BigDecimal(productTechnologyId);
	}
	
	public BigDecimal getProductId() {
		return this.productId;
	}
	
	public void setProductId (String  productId) {
		this.productId = (productId == null) || productId.isEmpty() ? null : new BigDecimal(productId);
	}
	
	public String getProductTechnologyName() {
		return this.productTechnologyName;
	}
	
	public void setProductTechnologyName(String productTechnologyName) {
		this.productTechnologyName = productTechnologyName;
	}
	
	public String getProductProperty() {
		return this.productProperty;
	}
	
	public void setProductProperty(String productProperty) {
		this.productProperty = productProperty;
	}
	
	public String getProductTechnologyRequire() {
		return this.productTechnologyRequire;
	}
	
	public void setProductTechnologyRequire(String productTechnologyRequire) {
		this.productTechnologyRequire = productTechnologyRequire;
	}
	
	public String getBeerPlateNo() {
		return this.beerPlateNo;
	}
	
	public void setBeerPlateNo(String beerPlateNo) {
		this.beerPlateNo = beerPlateNo;
	}
	
	public String getGoldPlateNo() {
		return this.goldPlateNo;
	}
	
	public void setGoldPlateNo(String goldPlateNo) {
		this.goldPlateNo = goldPlateNo;
	}
	
	public String getDieCutPlateNo() {
		return this.dieCutPlateNo;
	}
	
	public void setDieCutPlateNo(String dieCutPlateNo) {
		this.dieCutPlateNo = dieCutPlateNo;
	}
	
	public String getCopperpResinLateNo() {
		return this.copperpResinLateNo;
	}
	
	public void setCopperpResinLateNo(String copperpResinLateNo) {
		this.copperpResinLateNo = copperpResinLateNo;
	}
	
	public String getNetPlateNo() {
		return this.netPlateNo;
	}
	
	public void setNetPlateNo(String netPlateNo) {
		this.netPlateNo = netPlateNo;
	}
	
	public String getPackageStyle() {
		return this.packageStyle;
	}
	
	public void setPackageStyle(String packageStyle) {
		this.packageStyle = packageStyle;
	}
	
	public String getPhysicalTest() {
		return this.physicalTest;
	}
	
	public void setPhysicalTest(String physicalTest) {
		this.physicalTest = physicalTest;
	}
	
	public String getChemistryTest() {
		return this.chemistryTest;
	}
	
	public void setChemistryTest(String chemistryTest) {
		this.chemistryTest = chemistryTest;
	}
	
	public String getProductMaterial() {
		return this.productMaterial;
	}
	
	public void setProductMaterial(String productMaterial) {
		this.productMaterial = productMaterial;
	}
	
	public String getPlasticBagStructure() {
		return this.plasticBagStructure;
	}
	
	public void setPlasticBagStructure(String plasticBagStructure) {
		this.plasticBagStructure = plasticBagStructure;
	}
	
	public String getCopperpNo() {
		return this.copperpNo;
	}
	
	public void setCopperpNo(String copperpNo) {
		this.copperpNo = copperpNo;
	}
	
	public String getColorNoCard() {
		return this.colorNoCard;
	}
	
	public void setColorNoCard(String colorNoCard) {
		this.colorNoCard = colorNoCard;
	}
	
	public String getPlateNo() {
		return this.plateNo;
	}
	
	public void setPlateNo(String plateNo) {
		this.plateNo = plateNo;
	}
	
	public String getSurfaceTreatment() {
		return this.surfaceTreatment;
	}
	
	public void setSurfaceTreatment(String surfaceTreatment) {
		this.surfaceTreatment = surfaceTreatment;
	}
	
	public String getProductDescribe() {
		return this.productDescribe;
	}
	
	public void setProductDescribe(String productDescribe) {
		this.productDescribe = productDescribe;
	}
	
	public String getProductFront() {
		return this.productFront;
	}
	
	public void setProductFront(String productFront) {
		this.productFront = productFront;
	}
	
	public String getProductOpposite() {
		return this.productOpposite;
	}
	
	public void setProductOpposite(String productOpposite) {
		this.productOpposite = productOpposite;
	}
	
	public String getRiskDescription() {
		return this.riskDescription;
	}
	
	public void setRiskDescription(String riskDescription) {
		this.riskDescription = riskDescription;
	}
	
	public String getHaveDrawing() {
		return this.haveDrawing;
	}
	
	public void setHaveDrawing(String haveDrawing) {
		this.haveDrawing = haveDrawing;
	}
	
	public String getIsShoePicture() {
		return this.isShoePicture;
	}
	
	public void setIsShoePicture(String isShoePicture) {
		this.isShoePicture = isShoePicture;
	}
	
	public Integer getBeerPlateNum() {
		return this.beerPlateNum;
	}
	
	public void setBeerPlateNum(Integer beerPlateNum) {
		this.beerPlateNum = beerPlateNum;
	}
	
	public Integer getDieBoardNum() {
		return this.dieBoardNum;
	}
	
	public void setDieBoardNum(Integer dieBoardNum) {
		this.dieBoardNum = dieBoardNum;
	}
	
	public String getCutDirection() {
		return this.cutDirection;
	}
	
	public void setCutDirection(String cutDirection) {
		this.cutDirection = cutDirection;
	}
	
	public String getCustomsCommodityCode() {
		return this.customsCommodityCode;
	}
	
	public void setCustomsCommodityCode(String customsCommodityCode) {
		this.customsCommodityCode = customsCommodityCode;
	}
}
