package com.huigou.topsun.product.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author YourUserName
 * 颜色
 */
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
@Entity
@Table(name = "color")
public class Color implements Serializable {

	/**
	 * 颜色ID
	 */
	@Id
	@JsonSerialize(using = NumberToStringSerializer.class)
	@Column(name = "color_id", nullable = false)
	private BigDecimal colorId;

	/**
	 * 颜色名称
	 */
	@Column(name = "color_name", nullable = true, length = 128)
	private String colorName;

	/**
	 * 颜色编码
	 */
	@Column(name = "color_code", nullable = true, length = 32)
	private String colorCode;

	/**
	 * 备注
	 */
	@Column(name = "color_remark", nullable = true, length = 255)
	private String colorRemark;
	
	public BigDecimal getColorId() {
		return this.colorId;
	}
	
	public void setColorId (String  colorId) {
		this.colorId = (colorId == null) || colorId.isEmpty() ? null : new BigDecimal(colorId);
	}
	
	public String getColorName() {
		return this.colorName;
	}
	
	public void setColorName(String colorName) {
		this.colorName = colorName;
	}
	
	public String getColorCode() {
		return this.colorCode;
	}
	
	public void setColorCode(String colorCode) {
		this.colorCode = colorCode;
	}
	
	public String getColorRemark() {
		return this.colorRemark;
	}
	
	public void setColorRemark(String colorRemark) {
		this.colorRemark = colorRemark;
	}
}
