package com.huigou.topsun.demo.controller;

import com.huigou.cache.DictUtil;
import com.huigou.topsun.resource.service.ResourceFiledService;
import com.huigou.topsun.technology.application.ProcessApplication;
import com.huigou.topsun.technology.domain.query.ProcessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.easysearch.EasySearch;
import com.huigou.uasp.bmp.common.easysearch.domain.model.EasySearchParse;
import com.huigou.uasp.bmp.common.easysearch.domain.model.QuerySchemeField;
import com.huigou.uasp.bmp.configuration.application.DictionaryApplication;
import com.huigou.uasp.bmp.opm.application.MemEasySearcher;
import com.huigou.uasp.bmp.opm.application.impl.MemEasySearcherImpl;
import com.huigou.util.SDO;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/24/10:07
 * @Description:
 */
@Controller
@ControllerMapping("/resourceNameGroup")
public class ResourceSearchController {
    @Resource
    private ResourceFiledService resourceFiledService;
    @Resource
    private ProcessApplication processApplication;
    @EasySearch(queryName = "resourceNameGroup")
    public Map<String, Object> queryResourceNameGroup(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("id", "id", "hidden"),
                        new QuerySchemeField("资源名称", "gxmc", "string", 200L),
                        new QuerySchemeField("资源编码", "gxbm", "string", 100L),
                        new QuerySchemeField("单位", "dw", "string", 100L),
                        new QuerySchemeField("用量", "yl", "string", 100L),
                        new QuerySchemeField("工作中心", "gzzx", "string", 100L));
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
        String processType = sdo.getString("paramValue");
        List<Map<String, Object>> mapList = resourceFiledService.getResourceFieldValueListByProcess(processType);
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }

    @EasySearch(queryName = "processNameGroup")
    public Map<String, Object> queryProcessNameGroup(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("processId", "processId", "hidden"),
                        new QuerySchemeField("工序名称", "processName", "string", 200L),
                        new QuerySchemeField("工序类型", "processType", "hidden", 100L),
                        new QuerySchemeField("工序类型", "processTypeTextView", "string", 100L),
                        new QuerySchemeField("工时", "workHours", "string", 100L),
                        new QuerySchemeField("工序内容", "processContent", "hidden", 100L),
                        new QuerySchemeField("工序说明", "processRemark", "hidden", 100L)
                );
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
        String processName = sdo.getString("paramValue");
        ProcessQueryRequest queryRequest = sdo.toQueryRequest(ProcessQueryRequest.class);
        queryRequest.setProcessName(processName);
        Map<String, Object> map = processApplication.slicedProcessList(queryRequest);
        List<Map<String, Object>> mapList =  (List<Map<String, Object>>)map.get("Rows");
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }

    @EasySearch(queryName = "productChoose")
    public Map<String, Object> productChoose(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("productId", "productId", "hidden"),
                        new QuerySchemeField("产品编码", "productCode", "string", 200L),
                        new QuerySchemeField("产品名称", "productName", "hidden", 200L),
                        new QuerySchemeField("计量单位", "productUnit", "string", 100L)
                );
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
        Map<String ,Object> map = new HashMap<>();
        map.put("productId","1");
        map.put("productCode","1");
        map.put("productName","测试");
        map.put("productUnit","张");
        Map<String ,Object> map2 = new HashMap<>();
        map2.put("productId","2");
        map2.put("productCode","2");
        map2.put("productName","测试2");
        map2.put("productUnit","张");
        List<Map<String,Object>> mapList = new ArrayList<>();
        mapList.add(map);
        mapList.add(map2);
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }

    @EasySearch(queryName = "sapMaterialSelect")
    public Map<String, Object> sapMaterialSelect(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("materialId", "materialId", "hidden"),
                        new QuerySchemeField("物料名称", "materialName", "string", 200L),
                        new QuerySchemeField("SAP物料相关内容", "materialJson", "hidden", 200L),
                        new QuerySchemeField("物料计量单位", "materialUnit", "string", 100L)
                );
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
        Map<String ,Object> map = new HashMap<>();
        map.put("materialId","1");
        map.put("materialName","测试物料1");
        map.put("materialJson","相关内容11");
        map.put("materialUnit","张");
        Map<String ,Object> map2 = new HashMap<>();
        map2.put("materialId","2");
        map2.put("materialName","测试物料2");
        map2.put("materialJson","相关内容22");
        map2.put("materialUnit","张");
        List<Map<String,Object>> mapList = new ArrayList<>();
        mapList.add(map);
        mapList.add(map2);
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }

    @EasySearch(queryName = "knttp")
    public Map<String, Object> knttpSelect(SDO sdo){
        Integer intPage = sdo.getInteger("intPage", 1);
        Integer pageSize = sdo.getInteger("pageSize",10);
        PageRequest pageRequest = new PageRequest(intPage - 1, pageSize);
        List<QuerySchemeField> fields =
                Arrays.asList(new QuerySchemeField("科目分配类别", "knttp", "string", 100L));
        EasySearchParse easySearchParse = new EasySearchParse();
        easySearchParse.setFields(fields);
        easySearchParse.setWidth(450L);
        List<Map<String,Object>> mapList = new ArrayList<>();
        String paramValue = sdo.getString("paramValue");
        Map<String, String> knttp = DictUtil.getDictionary("knttp");
        knttp.forEach((key, value) -> {
            Map<String, Object> map = new HashMap<>();
            map.put("knttp", value);
            if ("ZFW".equals(paramValue)) {
                mapList.add(map);
            } else if ("ZNE1".equals(paramValue)) {
                if ("A".equals(key)) {
                    mapList.add(map);
                }
            } else if ("ZNE2".equals(paramValue)) {
                if ("F".equals(key) || "K".equals(key)) {
                    mapList.add(map);
                }
            }
        });
        MemEasySearcher<Map<String, Object>> memEasySearcher = new MemEasySearcherImpl<>();
        Map<String, Object> model = memEasySearcher.search(mapList, easySearchParse, pageRequest, null);
        return model;
    }
}
