package com.huigou.topsun.customer.domain.vo;

import com.alibaba.fastjson.JSON;
import com.huigou.topsun.customer.domain.CustomerRelated;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * title:
 * author:ZHT
 * date:2023/12/19
 * description:
 */
@Data
public class CustomerRelatedVo implements Serializable {
    /**
     * 关联客户id
     */
    private String customerRelatedId;

    /**
     * 客户id
     */
    private String customerId;

    /**
     * 关联客户编码
     */
    private String customerCodeRelated;

    /**
     * 关联客户简称
     */
    private String customerShortNameRelated;

    /**
     * 关联客户全称
     */
    private String customerNameRelated;

    /**
     * 录入人
     */
    private String createdByName;

    /**
     * 录入时间
     */
    private Date createdDate;

    public static CustomerRelated  getCustomerRelated(CustomerRelatedVo customerRelatedVo){
        return JSON.parseObject(JSON.toJSONString(customerRelatedVo),CustomerRelated.class);
    }
    public static CustomerRelatedVo getCustomerRelatedVo(CustomerRelated customerRelated){
        return JSON.parseObject(JSON.toJSONString(customerRelated), CustomerRelatedVo.class);
    }

}
