package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户订单信息
 * @TableName customer_order
 */
@Table(name="customer_order")
@Entity
@Data
public class CustomerOrder implements Serializable {
    /**
     * 客户订单信息
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_order_id")
    private String customerOrderId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 请款要求
     */
    @Column(name = "payment_request")
    private String paymentRequest;

    /**
     * 扣款百分比
     */
    private Integer deduction;

    /**
     * 是否要求签回货单
     */
    @Column(name = "signed_back")
    private String signedBack;

    /**
     * 是否用客户系统货单
     */
    @Column(name = "customer_sys_order")
    private String customerSysOrder;

    /**
     * 报价币别（currency）
     */
    @Column(name = "quotation_currency")
    private String quotationCurrency;

    /**
     * 金额小数位数
     */
    @Column(name = "decimal_places")
    private Integer decimalPlaces;

    /**
     * 签回方式（signedStyle）
     */
    @Column(name = "signed_style")
    private String signedStyle;

    /**
     * 月结方式（monthlySettlementMethod）
     */
    @Column(name = "monthly_settlement_method")
    private String monthlySettlementMethod;

    /**
     * 做账难度等级（accountDifficultLevel）
     */
    @Column(name = "account_difficult_level")
    private String accountDifficultLevel;

    /**
     * 盖章方式（stampMethod）
     */
    @Column(name = "stamp_method")
    private String stampMethod;

    /**
     * 请款联（paymentRequestForm）
     */
    @Column(name = "payment_request_form")
    private String paymentRequestForm;

    /**
     * 客户联（customerReceipt）
     */
    @Column(name = "customer_receipt")
    private String customerReceipt;

    /**
     * 订单性质（orderKind）
     */
    @Column(name = "order_kind")
    private String orderKind;

    /**
     * 品牌
     */
    @Column(name = "customer_brand")
    private String customerBrand;

    /**
     * 收货方签字要求
     */
    @Column(name = "receiver_signature_require")
    private String receiverSignatureRequire;

    /**
     * 出货方式（shipMethod）
     */
    @Column(name = "ship_method")
    private String shipMethod;

    /**
     * 路线（route）
     */
    private String route;

    /**
     * 备注
     */
    private String remark;

    /**
     * 订单要求（orderRequire）
     */
    @Column(name = "order_require")
    private String orderRequire;

    /**
     * 验收要求
     */
    @Column(name = "acceptance_require")
    private String acceptanceRequire;

    /**
     * 客户系统验收要求
     */
    @Column(name = "customer_sys_acceptance_require")
    private String customerSysAcceptanceRequire;

    /**
     * 做账截止日期
     */
    @Column(name = "account_deadline")
    private Integer accountDeadline;

    /**
     * 客户收账单截止日
     */
    @Column(name = "customer_collection_deadline")
    private Integer customerCollectionDeadline;

    /**
     * 订单统计异常期限
     */
    @Column(name = "order_abnormal_deadline")
    private Integer orderAbnormalDeadline;

    /**
     * 送货单统计异常期限
     */
    @Column(name = "ship_abnormal_deadline")
    private Integer shipAbnormalDeadline;

    /**
     * 请款期限
     */
    @Column(name = "payment_deadline")
    private Integer paymentDeadline;

    /**
     * 产品检验报告类型（productInspectionReportType）
     */
    @Column(name = "product_inspection_report_type")
    private String productInspectionReportType;

    /**
     * 货单打印要求（shipPrintRequire）
     */
    @Column(name = "ship_print_require")
    private String shipPrintRequire;

    /**
     * 货单是否打印送货日期
     */
    @Column(name = "is_print_delivery_date")
    private String isPrintDeliveryDate;

    /**
     * 是否开发票
     */
    @Column(name = "need_invoice")
    private String needInvoice;

    /**
     * 生产交货方式（productionDeliveryMethod）
     */
    @Column(name = "production_delivery_method")
    private String productionDeliveryMethod;

    private static final long serialVersionUID = 1L;
}